% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_prob.R
\name{transition_probability}
\alias{transition_probability}
\title{State Transition Probability}
\usage{
transition_probability(x, z, K_max, prob = 1/3)
}
\arguments{
\item{x}{positive integer indicating the current state.}

\item{z}{positive integer indicating the proposal state.}

\item{K_max}{positive integer indicating the maximum value allowed for \code{x} and \code{z}.}

\item{prob}{probability of jumping from state \code{x} to state \code{x} if \code{x} doesn't equal to K_max nor 1.}
}
\value{
A transition probability from state \code{x} to state \code{z}.
}
\description{
This function computes the transition probability from current state x to the proposal state z belonging to the neighbor of x (\emph{i.e.,} \eqn{z \in {x-1, x, x+1}}).
}
\details{
This function computes the transition probability from current state x to the proposal state z. If x doesn't equal to \code{K_max} nor 1 and z belongs to the neighbor of x (\emph{i.e., {x-1,x,x+1}}), then the transition probability is \code{prob}, else 0. If x equals to 1 or K_max, then the transition probability from x to z belongs to {1,2} or {K_max-1, K_max} is 0.5, else 0.
}
\examples{
transition_probability(2, 3, 50, 1/3)
}
\keyword{internal}

