% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OwenT.R
\name{OwenT}
\alias{OwenT}
\title{Owen T-function}
\usage{
OwenT(h, a)
}
\arguments{
\item{h}{numeric scalar}

\item{a}{numeric scalar}
}
\value{
A number between \code{0} and \code{0.25}.
}
\description{
Evaluates the Owen T-function.
}
\details{
This is a port of the function \code{owens_t} of the \strong{boost}
collection of C++ libraries.
}
\examples{
integrate(function(x) pnorm(1+2*x)^2*dnorm(x), lower=-Inf, upper=Inf)
pnorm(1/sqrt(5)) - 2*OwenT(1/sqrt(5), 1/3)
}
\references{
Owen, D. B. (1956).
Tables for computing bivariate normal probabilities.
\emph{Ann. Math. Statist.} \bold{27}, 1075-1090.
}
