% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrthoPanels-package.R
\name{abond_panel}
\alias{abond_panel}
\title{UK Company Data Panel}
\format{A data frame with 813 rows and 16 variables}
\description{
The dynamics of labour demand of firm \eqn{id} in the United Kingdom
in year \eqn{year} as a function of real product wages, gross capital
stock and industry output. This is done using the data used by
Arellano and Bond (1991).
}
\details{
A survey of 1845 respondents using 3 waves of panel survey data
from the 2010 British Election Study. The variables are as follows:

\itemize{
  \item id case number
  \item year time wave
  \item n log of employment in firm \code{id} at time \code{year}
  \item w natural log of the real product wage
  \item k natural log of gross capital stock
  \item ys natural log of industry output
  \item l_w lag of \code{w}
  \item l_k lag of \code{k}
  \item l2_k two-step lag of \code{k}
  \item l_ys lag of \code{ys}
  \item l2_ys two-step lag of \code{ys}
  \item yr1980..yr1984 time dummies
}
}
\references{
Arrelano M., and Bond S. (1991) Some Tests of Specification for
Panel Data: Monte Carlo Evidence and an Application to Employment
Equations. \emph{Review of Economic Studies}, \bold{58(2)},
277--297.
}

