% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_spec.R
\name{cor_spec}
\alias{cor_spec}
\alias{cor_spec.default}
\alias{cor_spec.OpenSpecy}
\alias{match_spec}
\alias{match_spec.default}
\alias{match_spec.OpenSpecy}
\alias{ident_spec}
\alias{get_metadata}
\alias{get_metadata.default}
\alias{get_metadata.OpenSpecy}
\alias{max_cor_named}
\alias{filter_spec}
\alias{filter_spec.default}
\alias{filter_spec.OpenSpecy}
\alias{ai_classify}
\alias{ai_classify.default}
\alias{ai_classify.OpenSpecy}
\title{Identify and filter spectra}
\usage{
cor_spec(x, ...)

\method{cor_spec}{default}(x, ...)

\method{cor_spec}{OpenSpecy}(x, library, na.rm = T, ...)

match_spec(x, ...)

\method{match_spec}{default}(x, ...)

\method{match_spec}{OpenSpecy}(
  x,
  library,
  na.rm = T,
  top_n = NULL,
  order = NULL,
  add_library_metadata = NULL,
  add_object_metadata = NULL,
  fill = NULL,
  ...
)

ident_spec(
  cor_matrix,
  x,
  library,
  top_n = NULL,
  add_library_metadata = NULL,
  add_object_metadata = NULL,
  ...
)

get_metadata(x, ...)

\method{get_metadata}{default}(x, ...)

\method{get_metadata}{OpenSpecy}(x, logic, rm_empty = TRUE, ...)

max_cor_named(cor_matrix, na.rm = T)

filter_spec(x, ...)

\method{filter_spec}{default}(x, ...)

\method{filter_spec}{OpenSpecy}(x, logic, ...)

ai_classify(x, ...)

\method{ai_classify}{default}(x, ...)

\method{ai_classify}{OpenSpecy}(x, library, fill = NULL, ...)
}
\arguments{
\item{x}{an \code{OpenSpecy} object, typically with unknowns.}

\item{library}{an \code{OpenSpecy} or \code{glmnet} object representing the
reference library of spectra or model to use in identification.}

\item{na.rm}{logical; indicating whether missing values should be removed
when calculating correlations. Default is \code{TRUE}.}

\item{top_n}{integer; specifying the number of top matches to return.
If \code{NULL} (default), all matches will be returned.}

\item{order}{an \code{OpenSpecy} used for sorting, ideally the unprocessed
one; \code{NULL} skips sorting.}

\item{add_library_metadata}{name of a column in the library metadata to be
joined; \code{NULL} if you don't want to join.}

\item{add_object_metadata}{name of a column in the object metadata to be
joined; \code{NULL} if you don't want to join.}

\item{fill}{an \code{OpenSpecy} object with a single spectrum to be used to
fill missing values for alignment with the AI classification.}

\item{cor_matrix}{a correlation matrix for object and library,
can be returned by \code{cor_spec()}}

\item{logic}{a logical or numeric vector describing which spectra to keep.}

\item{rm_empty}{logical; whether to remove empty columns in the metadata.}

\item{\ldots}{additional arguments passed \code{\link[stats]{cor}()}.}
}
\value{
\code{match_spec()} and \code{ident_spec()} will return
a \code{\link[data.table]{data.table-class}()} containing correlations
between spectra and the library.
The table has three columns: \code{object_id}, \code{library_id}, and
\code{match_val}.
Each row represents a unique pairwise correlation between a spectrum in the
object and a spectrum in the library.
If \code{top_n} is specified, only the top \code{top_n} matches for each
object spectrum will be returned.
If \code{add_library_metadata} is \code{is.character}, the library metadata
will be added to the output.
If \code{add_object_metadata} is \code{is.character}, the object metadata
will be added to the output.
\code{filter_spec()} returns an \code{OpenSpecy} object.
\code{cor_spec()} returns a correlation matrix.
\code{get_metadata()} returns a \code{\link[data.table]{data.table-class}()}
with the metadata for columns which have information.
}
\description{
\code{match_spec()} joins two \code{OpenSpecy} objects and their metadata
based on similarity.
\code{cor_spec()} correlates two \code{OpenSpecy} objects, typically one with
knowns and one with unknowns.
\code{ident_spec()} retrieves the top match values from a correlation matrix
and formats them with metadata.
\code{get_metadata()} retrieves metadata from OpenSpecy objects.
\code{max_cor_named()} formats the top correlation values from a correlation
matrix as a named vector.
\code{filter_spec()} filters an Open Specy object.
}
\examples{
data("test_lib")

unknown <- read_extdata("ftir_ldpe_soil.asp") |>
  read_any() |>
  conform_spec(range = test_lib$wavenumber,
               res = spec_res(test_lib)) |>
  process_spec()
cor_spec(unknown, test_lib)

match_spec(unknown, test_lib, add_library_metadata = "sample_name",
           top_n = 1)

}
\seealso{
\code{\link{adj_intens}()} converts spectra;
\code{\link{get_lib}()} retrieves the Open Specy reference library;
\code{\link{load_lib}()} loads the Open Specy reference library into an \R
object of choice
}
\author{
Win Cowger, Zacharias Steinmetz
}
