% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{importScivesco}
\alias{importScivesco}
\title{Import sci:vesco data files.}
\usage{
importScivesco(file, dir = NULL)
}
\arguments{
\item{file}{Filename including path if file is not in current working
directory. File can also be a complete URL. The fileformat
is .dat.}

\item{dir}{Alternative way to supply the directory where the file is located
(default \code{NULL}).}
}
\value{
A single \code{repgrid} object in case one file and
a list of \code{repgrid} objects in case multiple files are imported.
}
\description{
Import sci:vesco data files.
}
\note{
Sci:Vesco offers the options to rate the construct poles separately or using a bipolar scale. The separated
rating is done using the "tetralemma" field. The field is a bivariate plane on which each of the four (tetra)
corners has a different meaning in terms of rating. Using this approach also allows ratings like: "both poles
apply", "none of the poles apply" and all intermediate ratings can be chosen. This relaxes the bipolarity
assumption often assumed in grid theory and allows for deviation from a strict bipolar rating if the constructs
are not applied in a bipolar way. Using the tetralemma field for rating requires to analyze each construct
separately though. This means we get a double entry grid where the emergent and contrast pole ratings might not
simply be a reflection of on another. The tetralemma field is not yet supported and importing will fail. Currently
only bipolar ratings are supported.

If a tetralemma field has been used for rating, \code{OpenRepGrid} will offer the option to transform the scores into
"normal" grid ratings (i.e. restricted to bipolarity) by projecting the ratings from the bivariate tetralemma
field onto the diagonal of the tetralemma field and thus forcing a bipolar rating type. This option is not
recommended due to the fact that the conversion is susceptible to error when both ratings are near to zero.

TODO: For developers: The element IDs are not used yet. This might cause wrong assignments.
}
\examples{
\dontrun{

# supposing that the data file scivesco.scires is in the current directory
file <- "scivesco.scires"
rg <- importScivesco(file)

# specifying a directory (arbitrary example directory)
dir <- "/Users/markheckmann/data"
rg <- importScivesco(file, dir)

# using a full path
rg <- importScivesco("/Users/markheckmann/data/scivesco.scires")
}
}
\references{
Menzel, F., Rosenberger, M., Buve, J. (2007). Emotionale, intuitive und
rationale Konstrukte verstehen. \emph{Personalfuehrung, 4}(7), 91-99.
}
\seealso{
\code{\link[=importGridcor]{importGridcor()}}, \code{\link[=importGridstat]{importGridstat()}}, \code{\link[=importScivesco]{importScivesco()}}, \code{\link[=importGridsuite]{importGridsuite()}}, \code{\link[=importTxt]{importTxt()}},
\code{\link[=importExcel]{importExcel()}}
}
