#   Copyright 2007-2018 The OpenMx Project
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
# 
#        http://www.apache.org/licenses/LICENSE-2.0
# 
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.


#------------------------------------------------------------------------------
# Author: Sarah Medland
# Date: 2018-03-08
# Date: 2018-03-08 17:00:47 by mhunter
# Filename: MxRetro.R
# Purpose: Returns random clasic Mx error message
#------------------------------------------------------------------------------


##' Return random classic Mx error message
##' 
##' @description
##' This function allows you to obtain a classic Mx error message.
##' The message returned is random.
##' 
##' @details
##' If you're a nostalgic old sod and you miss the warm, fuzzy
##' feelings you got from reading one of Mike Neale's pattented error messages,
##' then this function is here to save you from the depths of dire depression.
##' All credit for this function is due to Sarah Medland, but of course the wisdom
##' is from Mike Neale.
##' 
##' @seealso - \code{\link{omxBrownie}}
##' @references - \url{https://en.wikipedia.org/wiki/OpenMx}
##' @examples
##' require(OpenMx)
##' mxRetro()
mxRetro <- function ( ) 
{
    mikes_wisdom <- list("First input line after title must be DATA. Will occur if the Title line has been forgotten. Maybe, just MAYBE, you got your NG wrong.",
	"Data line must have NI and NO specified. (Data groups only).",
	"End of file while trying to read title.",
	"Must specify Matrices at this point... Perhaps you have the wrong NI or the wrong matrix type - SY instead of FU?",
	"Not a legal matrix name. Use A-Z, one letter only.",
	"Illegal matrix type... Check for typos. You may use ZE, ID, IZ, ZI, DI, SD, SY, ST, FU, UN or LO.",
	"Sorry, I seem to be at the end of your input file. Check NG is correct.",
	"Number of selected variables must be less than or equal to number of input variables NI ... Otherwise you won't be analyzing something sensible and positive definite.",
	"Error - no variables selected for analysis.",
	"Terribly sorry, I don't have enough workspace.",
	"Please try not to refer to matrices that you haven't specified.",
	"Please use only Pattern or Specification throughout. Pattern and Specification cannot be used in the same input file.",
	"Error - no matrix specified...",
	"More than 3 dimensions specified. After a matrix name, there should be a maximum of 3 numbers to identify the element.",
	"Error - matrix has not been specified.",
	"Matrix has been specified not to have free elements. See Table ? to figure out which types of matrix can have free elements.",
	"You cannot alter off-diagonal elements of a diagonal matrix.",
	"Incorrect element of a Subdiagonal matrix specified. You can't alter elements on or above the diagonal of as Subdiagonal matrix.",
	"Incorrect element of a Standardized matrix specified. You can't alter elements on the diagonal of a Standardized matrix.",
	"Please use 2 or 3 dimensional format for elements. Array references should be group,row,col, with group optional.",
	"Sorry, I can't find your matrix element. I really should tidy up sometime.",
	"I'm sorry, I don't understand this part of DATA line, so I'm ignoring it. Note that MX is not LISREL and won't fiddle about changing data structures using the MA= command syntax. You can always do it explicitly in a little MX job which will be good for your immortal soul.",
	"Sorry, I couldn't invert your expected matrix. If the method is ML, the expected matrix has to be invertible throughout optimization. MX will try to avoid non-positive definite areas with a penalty function.",
	"Sorry, I couldn't invert your asymptotic matrix. If the asymptotic matrix is not positive definite, it must be fixed. Check the Select command for repetitions of a number, if it is used.",
	"Strangely, you seem to have requested an unknown matrix operation. IF you get this one, memory is screwed up somehow, and you should check your input file carefully before sending the problem to Mike Neale.",
	"Sorry, your model matrix has different dimensions from your data matrix. A common silly mistake. Carefully figure out the dimension of your model, check NI parameter and Select command if used.",
	"Sorry, your expected matrix is not symmetric. The matrix formula you provide should yield a matrix that is symmetric, if it is to be fitted to data.",
	"Sorry, you must have symmetric or full model Same as previous message.",
	"Please try not to specify inverse for non-square matrices. Generalized inverses are not available. If you are desperate, try transforming to a partitioned matrix that has a square matrix of full rank at one end.",
	"Sorry, had trouble transposing a matrix. This is an unlikely error.",
	"Sorry, I couldn't find the determinant of a matrix. I thought I put it on the shelf here somewhere... Probably zero.",
	"Uh-oh.. there's a problem with a binary operator. This can happen when evaluating an illegal matrix expression, but it is unlikely.",
	"Sorry, the matrix addition screwed up. Very unlikely.",
	"The matrices you wish to add are not conformable for addition i.e. the number of rows (columns) in matrix 1 is not the same as the number of rows (columns) in matrix 2. Quite likely. If at first you don't succeed, check check and check again.",
	"The matrices you wish to multiply are not conformable for multiplication i.e. the number of columns in matrix 1 is not the same as the number of rows in matrix 2. Be sure that you are using the right type of multiplication for your application, as well as checking the dimensions of the matrices you wish to multiply.",
	"You seem to have an unknown matrix type. Very unlikely.",
	"I seem to be using an unknown fit function. Very unlikely.",
	"You must specify 3 numbers for boundary constraints. Lower bound, Upper bound, Parameter # or array element.",
	"First character after BOUNDARY must be alphanumeric. Alphanumeric means alphabetic abcdefghijklmnopqrstuv or 01234356789.",
	"Sorry, to request AWLS for this group, you should have input an asymptotic covariance matrix.",
	"I don't know to what you want me to equate this matrix. Some error in the =Mi command to equate matrices. Equatee must be on the same input line.",
	"Sorry, I can't make this matrix equal to a matrix that you haven't supplied yet. Reorder your groups if it isn't a typo.",
	"Uh-oh... I got stuck inverting a matrix while calculating expected matrix... If you are using an (I-B)~ formulation, make sure that the parameters in B do NOT have bounds +1 or -1. This error is a pain in the neck. If you get it a lot, let me know. This can be awkward. Sometimes starting values or changing the boundaries on parameters can help.",
	"Uh-oh... I'm having trouble reading a number in D or E format. Probably a typo in the data.",
	"Sorry - could you put the =filename on the same line as the FI, please?",
	"Awfully sorry, I couldn't open a file for you. Probably a spelling mistake in the filename.",
	"I deeply regret that your equality constraint refers to a non-existent matrix.",
	"OH NO! The IOP parameter calling MSOFAR is wrong. I have no idea what this error means. The good thing about it is that you are not likely to get it.",
	"Please don't mix the numeric and array references on a Bound line! Use only parameter numbers or only matrix elements. I just get so terribly confused.",
	"There I was, looking for a number and - blow me down... - I just could not find it. Probably an error in specifying the dimensions of a matrix. The end of file was found before the number.",
	"It seems rather strange to me to have a + or - sign without a number after it. Well, wouldn't it seem strange to you?",
	"You seemed to put a  in the middle of two numbers but WRONGLY. Do not pass GO, do not collect $200.",
	"Uh-oh. Now there are too many numbers in a list.",
	"Nincompoop. Your data matrix has to be positive definite for GLS. Probably a little harsh, this message.",
	"Ouch! do not try to change your mind about the number of groups NG... This used to cause big headaches.",
	"Awfully sorry, old chap, you're trying to | between matrices that have a different number of rows. No can do! Check conformability.",
	"Awfully sorry, old chap, you're trying to _ between matrices that have a different number of columns. No way! Check conformability.",
	"Uh-oh! Your formula has an illegal character. Edit your input file and arrest this character immediately. On the IBM RISC 6000 it can occur spuriously and irrationally if you leave blank spaces at the start of a line following an underscore. Heaven knows why.",
	"Uh-oh! Your matrix expression has a mistake in it. Please fix it. This could be unmatched parentheses, a missing operator or a missing matrix. Sorry that it isn't more specific... Also, the matrix formula is sensitive to un-trapped memory problems. One known possibility is that you have tried to do something to a range of matrices from different groups, e.g. Start 1 A 1 1 1 - A 4 3 3.",
	"There seems to a problem with your format in your data file. Put the format in parentheses () or use  to read data in free format.",
	"Oh dear! The model you specified does not give the same number of rows in the Expected Matrix as there are in the Observed Matrix for this group. Check the order of the model.",
	"Stack has overflowed - kick Mike Neale. This is not necessary to fix the job. Your complicated expression ought to be simplified by using a CALC group to precalculate part of it.",
	"The matrices you wish to subtract are not conformable for subtraction. i.e. the number of rows (columns) in matrix 1 is not the same as the number of rows (columns) in matrix 2. If this message doesn't add up to you, go back to elementary school.",
	"I'm terribly sorry, stack 1 has overflowed. Please abuse Mike Neale. Simplify your expression with CALC groups.",
	"I'm terribly sorry, stack 2 has overflowed. Please abuse Mike Neale. Simplify your expression with CALC groups.",
	"An undefined matrix has been encountered in the matrix formula. Look for typos in the formula, and in the matrices command. You're using a matrix that hasn't been specified for this group. ",
	"You seem to have missed out an operator... Matrix names should be single letters only. Check the matrix formula for matrix names that are more than one letter.",
	"At first you put % but then there was neither O nor E nor R after it. Please try not to make grammatical errors like this. So put O or E or R after it!",
	"You seem to be referring to parameter specifications for an Observed or Expected matrix... There is no way that you are going to be allowed to do this.",
	"I want you to get this right. If you equate to the Observed or Expected matrix, you must specify a symmetric or full matrix. Get it right.",
	"The matrix you are trying to equate to the O matrix is bigger than the Observed matrix following any selection. Make it smaller...",
	"The matrix you are trying to equate to the expected matrix is not the same size as the expected matrix for that group. The size of the expected matrix for that group is determined by the size of its observed matrix after selection. Make it the same size.",
	"You have to give NG after CA if the first group is a CALC group. So do it.",
	"Tut-tut! you are trying to dot-product two matrices that have different dimensions. This is different from ordinary matrix multiplication after all.",
	"I tried to read another group and hit the end of file instead. Either NG= is wrong in group 1, or your input file has been truncated. NG is probably wrong.",
	"Look buster, if you want to define your own function. Then please get your matrix formula to define a 1x1 matrix! See page92",
	"At first I thought you were going to use a function, but then... You didn't put \\det, \\tr, \\exp, \\ln, \\sqrt, \\v2d, \\d2v, \\m2v, \\v2s, \\v2f, \\eval, \\evec, \\ivec, \\ival, \\stnd, \\vech, \\vec, \\sin \\cos \\tan \\sinh \\cosh \\tanh \\muln - or any functions that I recognize, so I am confused.. You must have boobed somewhere.",
	"Sorry, I only calculate the determinant of SQUARE matrices.",
	"Sorry, I only calculate the trace of SQUARE matrices.",
	"I say, if you use the \\EXPonent operator, you must make sure that the exponent is a 1x1 matrix. You won't get this error message.",
	"I can't equate this matrix to the observed data of that group, because it hasn't got any!",
	"Hmmm sorry I don't understand this keyword. Check NI= and FU/FI status of data matrices.",
	"HEY! I thought you were going to say = but where's the =??",
	"You can only have MA=CM,PM, or KM right now - sorry!",
	"Pardon my ignorance here, but I don't understand this keyword. You should be using one of the following: CMatrix, PMatrix, KMatrix, ACov_matrix, Raw_data, MEans, SKew, KUrtosis, LAbels, SElect, or MATrices. Where at least the uppercase letters must be given. Quite possibly, an earlier command screwed up. This is commonly encountered in the middle of a list of numbers if the list is too long. This may be because you have given too many numbers for the type and size of the matrix concerned, or alternatively you may have specified the dimensions of that matrix incorrectly. Note that you should only supply numbers for the modifiable elements of a matrix, which depends heavily on the type of matrix. See Section 4.5 for details on numbers of elements in different types of matrices.",
	"Imagine this: I'm reading a number and I see a \\ character, so I think. I know, it must be \\PI or \\E BUT then to my surprise I see it is neither. Do be less surprising in your input.",
	"I'm sorry, I can't write a matrix that doesn't exist to a file. Remember, this matrix has to be defined in this group.",
	"To output matrices to files, use MX with 1 letter after it (exceptions %E %M %P %V) then an = sign. No spaces or anything else allowed.",
	"AAAAGH You can't assign parameters to the raw data vector.",
	"If you want to fit to the raw data vectors, you must put them in a vector that has 1 row and the columns less than or equal to the number of input variables before selection, if any.",
	"No, I won't let you do this. It would overwrite the first raw data observation. Go and edit your data instead.",
	"Uh-oh, attempt to take log of zero or negative value imminent.",
	"In order to use Maximum Likelihood to raw data, it is necessary to supply both a model for the covariances, and one for the means.",
	"Sorry, the expected matrix is singular just now.",
	"Just WHAT is this keyword supposed to mean? You should be using one of the following: MEan_structure, THresholds, COvariances, SPecify, MAtrix, PArameter, FIx, FRee, EQual, VAlue, STart, BOundary, OPtions, ENd, OUtput. Where at least the uppercase letters must be given. 96. You have tried to convert something that wasn't a vector into a matrix. Please try not to abuse \\v2 functions in this way.",
	"At your starting values, evaluation of the log-likelihood made me take the logarithm of something less than or equal to zero. Please revise the starting values. Nothing for it... change the starting values. This could be a problem if there are some gruesome outliers, in which case you'd have to edit your data... See page 138 for details of how to interpret and respond to the diagnostics printed along with this error message.",
	"Your boundary constraint refers to a parameter not yet specified.",
	"You have referred to a non-existent row of a matrix. It's silly mistakes like these that my job as a computer SO rewarding. MX has a lousy imagination when it comes to that sort of thing.",
	"You have referred to a non-existent column of a matrix. There are lots of non-existent columns in Athens and Rome.",
	"You can't use the keyword Full when reading diagonal weight matrices or means.",
	"SORRY I don't select DWLS with correlation matrices yet. Try again after midnight? Seriously, I'm sorry about this.",
	"Error - you seem to have a non-integer value for the type of person. Please check: (1) you have the right pedigree size here (2) you have an integer type identifier for everyone (3) Nothing screwed up in an earlier pedigree. Make sure that you have got your VL file right. Be extra careful about SAS missing values.",
	"Please, you must tell me the covariance matrix structure in terms of id codes. Use the IC command to do this, sometime after MO and before End.",
	"There is a variable in this pedigree whose id has not been given in the IC command. If no IC was given a variable who has an id greater than NI is present.. The mysterious stranger needs to be identified and deleted.",
	"Your model does not define the covariance between TWO people with this ID. Of course, by default it won't. You need to use the IC command correctly. See page 49.",
	"An element of a matrix that you have tried to \\sqrt() is less than zero. Please don't let this happen! This version of MX does not cater for complex numbers - most of the time.",
	"You tried to convert a vector of the wrong length to a symmetric matrix. Hah, didn't think I'd notice eh? ",
	"I am only prepared to raise the elements of a matrix to the power of a scalar. Please try to ensure the matrix to the right of a ^ is (1 x 1). Do you have any better ideas? Kroneckerize it or something like that?",
	"You tried to convert a vector of the wrong length to a FULL square matrix. Silly billy.",
	"Eigenvalues of square matrices only, please.",
	"Eigenvectors of square matrices only, please.",
	"I'm afraid that if you want to fit to raw data you MUST supply models for BOTH means and covariances. You have forgotten a model for the means. You might forget your head if it wasn't attached with lots of sinews etc. Of course, you may have asked for the wrong kind of fit function on the Options line.",
	"I'm afraid that if you want to fit to raw data you MUST supply models for BOTH means and covariances. You have forgotten a model for the covariances. This is the 783rd time you have made this mistake but you have probably forgotten about the other times. Of course, you may have asked for the wrong kind of fit function on the Options line.",
	"If you are using Multiple fits, it is impossible to change the matrix formulae - and you can't change boundaries either.",
	"If you wish to Specify, Pattern, or matrix a matrix, you have to specify the group number on the same line BEFORE the Specification, Pattern or Matrix statement.",
	"Please try not to refer to non-existent groups! I don't mind you having fantasies, but there are limits, you know.",
	"When using the Multiple option you MUST use 3 numbers to specify a matrix element: Group #, row # and column #.",
	"I'm so embarrassed. I ran out of workspace.",
	"To read labels for a matrix, you must use the syntax: LABEL <R or C> Name.",
	"Labels can't be given for a non-existent matrix. Or rather they can, but MX will stop. Actually they can, but then the program stops immediately.",
	"Labels may not begin with a number because it could confuse me later on.",
	"Labels have not been provided for the data, but you seem to be using them to select variables. Use numbers or ``Give me labels or give me ...''",
	"It would seem that you are trying to select a variable that you never supplied. I expect that, being human, you made a mistake in the Labels or Select list.",
	"I can't select a variable that doesn't exist. Make sure that NI is correct or fix the Select list.",
	"Sorry, you can use covariance structures ONLY in constraint or calculation groups; means not allowed.",
	"Incorrect element of a lower triangular matrix specified.",
	"Hey! You must have NInputvars=2 to use contingency tables. A contingency table effectively cross-tabulates two variables, hence NInputvars must be two on the Data line.",
	"I'm afraid that if you want to fit to contingency tables you MUST supply models for BOTH thresholds and covariances. You have forgotten a model for the thresholds. Are these lapses of memory getting more frequent? Can't remember?? Maybe you need a checkup... Alternatively you may have requested the wrong fit function on the options line.",
	"I'm afraid that if you want to fit to contingency tables you MUST supply models for BOTH thresholds and covariances. You have forgotten a model for the covariances. Are these lapses of memory getting more frequent? Can't remember?? Maybe you need a checkup... Perhaps you requested the wrong fit function on the options line?",
	"You must supply a matrix expression for the thresholds that will evaluate to a matrix with 2 rows and with at least as many columns as one less than the number of row categories or the number of column categories, whichever is greater i.e. max(nrowcat-1,ncolcat-1). See page 75 for details about thresholds.",
	"Sorry, but during optimization I have been asked to calculate a bivariate integral with a correlation of 1 or more. This is very unreasonable of you Please fix your model so that this doesn't happen. Use boundaries or something. Note that the correlation is critical here, not the covariance. The correlation is calculated from the expected covariance matrix (the result of the model or covariance statement) as covij \u00F7 %variivarjj.",
	"Yes I will fit to n x n contingency tables BUT... n must be greater than or equal to 2. I know a 1 \u00D7 n is feasible but I haven't written the code for it yet, OK? ",
	"If you want me to save or get an MX binary file then you MUST supply a filename on the same line It's just one of those things in life that you have to do.",
	"We must have misunderstood each other somehow. You can't get expected proportions %P from a group that isn't using contingency tables.",
	"I think memory is screwed up because Mike Neale has screwed up.  Has screwed up or is screwed up?",
	"Well well well. You would like graphics. If so why don't you put an = after the DR command??? MX likes = signs before filenames. I don't know how it got into this habit.",
	"To fit to mean structures as well as covariances you should provide both observed means and a model for them (as well you know!) I'm going to use the covariances, but the mean - I'm just going to ignore it OK? Watch out for this one if you don't seem to get any action with the means.",
	"Really I'm very very sorry about this. It is not under my control. Unless of course I was to use a better language than FORTRAN77 I suppose... However enough philosophising, the problem is that we have reached the end of file too soon. Since you are using  format, you should put one case per line. That is to say, there should be NObs lines each with NI variables in a RA data file. Sometimes error messages are not just explicit, they are introspective. How would you like to be a computer program? Could be our species' destiny.",
	"Really I'm very very sorry about this. It is not under my control. Unless of course I was to use a better language than FORTRAN77 I suppose... However enough philosophy, the problem is that we have reached the end of file too soon. Make sure that your format is OK. Also, remember there should be NObs  NI numbers in your RA data file. See previous error message for sci-fi remark.",
	"Very funny. Hahaha. You want me to standardize a non-square matrix? Just how am I supposed to do that? If you get any ideas, let me know.",
	"It is with great sadness that I have to tell you that I couldn't standardize your matrix because the number I'm supposed to divide by is too small. Perhaps you could avoid this problem with boundary constraints. Poor machine, it tried!",
	"You are in terrible danger. Don't say multiple until the last group. I know I could have just remembered for you, but I'm lazy too! There are only so many hours in the day.",
	"Sorry, old chap. You can't specify boundary constraints after options. I might remedy this problem one day, but for now just meekly go back and put boundary constraints before the first option line in this group.",
	"Cough, ahem... can you please give me a matrix that has 1 row and 2 column for the power transformation?? Currently it is only possible to apply a transformation to all variables within each vector. This should be upgraded if there is ever support for MX; call your political representative now to safeguard its future...",
	"For heaven's sake! Can't you bound your constant so that it is Greater than minus the minimum observation??! Really most nursery school children have a good idea why this should be done. Exponentiating (especially for non-integer exponents) numbers that are less than zero is mathematically awkward, requiring complex numbers and so on. To avoid complex arithmetic, whose implications are unclear to me in this context, MX demands that if, say, your minimum observation is -3.1, the constant required would have to be greater than +3.1.",
	"YIKES! There's something funny about the power function you request. Remember that after PO you should supply 2 numbers. The significance level (alpha) (0.0 < alpha < 1), and the degrees of freedom of the test (df > 0). Sometimes NAG chokes if alpha is close to 0 or 1. I can't think why this shouldn't be self-explanatory. The numbers should be on the same line as the Power keyword. Note that Power in this context refers to calculating the statistical power of the study (see page 114).",
	"I can calculate confidence intervals in the range 0 to 100. Please try to stay within these bounds'. Everyone has their limits, you know.",
	"Look here buster, the matrix you \\muln must have 3 more rows than it does columns.",
	"There is a problem with the multinormal integral that you tried to compute. See if you can be kinder to me by using bounds.",
	"Covariance matrices must be computed from sample sizes of at least 1. I suspect that you forgot to put the NObs= parameter on the data line.",
	"The operation you attempted using ^ is undefined in mathematics in this universe. Try using e.g. \\abs() if you can, or go to another universe!",
	"Look here buster, the matrix you \\mnor must have 4 more rows than it does columns.",
	"Unknown matrix operator encountered!",
	"Your observed covariance matrix is not positive-definite. Check that you are reading it in the correct format - Full or Symmetric.",
	"Ooops. Somehow I was expecting a matrix with 4 more rows than columns for the \\momnor function. Remember, they should be organized this way: Covariance matrix/Mean vector/Thresholds in terms of standardized units/Selection vector: 1=above, -1=below, 0=not selected/Quadrature parameter 0=default=16; max=64.",
	"Aha! You have tried to use algebra to create a matrix that already exists. This is strictly illegal in MX. Go directly to Jail. Do not pass go. Do not collect $200. And make sure you haven't forgotten the End Algebra; statement.",
	"Hmmm you can't call a matrix this. Not yet. Use single letters (A-Z) for now.",
	"After the BEGIN keyword I expected to see one of the keywords ALGEBRA or MATRICES. Are you dyslexic? Or am I?",
	"Well I was trying to find the above character, but even though I looked through the whole file. I could not find it. Perhaps you forgot it?",
	"You seem to have put two binary operators in a row, which is bad syntax. Might this be a typo? Just possibly?",
	"I figure that you are trying to redefine something in this multi-group script but you have not used a #define Group = n statement yet so I don't know which group it is you wish to change.",
	"Oh no you don't. You can't use a #define group statement unless you are (or rather I am) in multiple fit mode.",
	"Sorry, I don't understand what you are trying to #define.",
	"While searching for a number, I encountered a string more than 32 characters long. At first, I thought it might be a global variable, but it is probably just your mistake.",
	"So sorry! You can't use !@ in the title. It might confuse my front end.",
	"I was trying to read a number or a #define'd parameter, and although I found a delimiter, I got to the end of the line before I found the number.",
	"I know this is rather silly of me, but I really need to know both NI= and NO= in order to read the data sensibly. Please look at the DA line.",
	"Error: file not found: Check spelling and existence of file. Remember that UNIX is case sensitive. Filenames have a maximum of 80 characters including directory.",
	"Once I saw the begin keyword, I thought, 'Aha I bet this user is going to say algebra or matrices next.' Well I lost my bet. I don't know what you want to begin.",
	"You seem to be trying to end matrices with something other than 'end matrices;'. It's not that difficult, is it?",
	"This is a generic error message of no use to you whatsoever. Lots of software has error messages like this, so I thought MX should too. Please contact Mike Neale (neale@ruby.vcu.edu) for help.",
	"I'm terribly sorry about this old chap. You can't use QQ as a missing data flag. It's Just one of those things.",
	"Oh boy. There I was trying to read stuff in rectangular format for you. And then I came across a blank record. I suspect a mistake.",
	"Ker-splat! I ran into some peculiar FORTRAN read error. Check the data file for Suspicious Characters.",
	"An error has occurred while reading a rectangular file. Make sure that you don't have a FORMAT at the beginning and note, I can't read numbers that begin with D, Q or E.",
	"Oooooh! Weird one. Your data file seems to be empty.",
	"Why the hell not",
	"Sorry, I'm just not ready to save at this point.",
	"This might seem a bit picky of me, but if you are going to simulate data. I'd like to know HOW MANY cases to simulate. Please give NI=n on the Simulate line, where n is a positive integer. Thank you. 181. Now look here. To simulate data you need to have a matrix formula for the Covariances which is Square, i.e., rows = columns above.",
	"Well there I was, all ready to equate all the matrices in this group to those of a previous group, and then you didn't put which group on the same line. Try, e.g., Matrices = Group 1. Note that you must have a space after the word group.",
	"Unbalanced parentheses in your formula. I'm not big into Yin & Yan but this is one area that I'd like more balance.",
	"I can't give you the sort order of this column vector because it has more than one column!!",
	"Partition requires syntax \\part(A,B) where B has 4 rows and one column. Somehow you didn't do this right.",
	"No no no. The second matrix in the list \\part(A,B) must have 4 rows and 1 column.",
	"I'm afraid that you can't use & between matrices that are not conformable. In this case, the number of columns in the first matrix must equal the number of rows in the second matrix, which must be square (rows of b=cols of b).",
	"Look, how am I supposed to know what these elements outside the dimensions of the matrix are??",
	"The partition function is tricky, I know. Make sure that the coordinate (2nd) matrix has been initialized FIRST. See the example partit.mx for details on how to do this.",
	"OK wise guy that's far enough! The group you referenced with %O doesn't have an observed covariance matrix!",
	"The matrices you wish to divide with % are not conformable. The number of rows in matrix 1 must be the same as the number of rows in matrix 2, and the number of columns in matrix 1 must be the same as the number of columns in matrix 2.",
	"I believe you read in the inverse of a weight matrix, sir? In that case you can't use select variables, because it defeats the point of saving time by pre-inverting.",
	"To use the computed matrix type, you have to put = M 1 on the same line, where M is a matrix and 1 is an earlier group. I'm not psychic. How am I supposed to know which computed matrix you want it to equal?",
	"Hang on a minute! You can only use the computed matrix type to refer to matrices generated in a Begin Algebra section.",
	"Yoo-hoo! You're supposed to a letter here...",
	"Gadzooks! You didn't supply a compute statement in that group. Therefore, I can't make this matrix equal to the %E of it.",
	"Huh? I don't understand your optional command line parameters. Syntax should be e.g.,: mx -f -h -k 100 myfile.mx myfile.mxo where f denotes frontend, h requests html, and k is workspace. Note: -f implies reading from keyboard and writing to screen.",
	"You must put the filename on the same line when using !@get,!@put or !@exist.",
	"Huh?",
	"File exists; use !@PUT! to overwrite it.")
        selected <- round(runif(1, min = 1, max = 197),0)
        return( writeLines(strwrap(mikes_wisdom[[selected]], width = 0.9 * getOption("width"), indent = 0)))
}
