% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxRobustSE.R
\name{imxRobustSE}
\alias{imxRobustSE}
\title{imxRobustSE}
\usage{
imxRobustSE(model, details = FALSE)
}
\arguments{
\item{model}{An OpenMx model object that has been run}

\item{details}{logical. whether to return the full parameter covariance matrix}
}
\description{
This is an internal function exported for those people who know
what they are doing.
}
\details{
This function computes robust standard errors via a sandwich estimator.
The "bread" of the sandwich is the numerically computed inverse Hessian
of the likelihood function.  This is what is typically used for standard
errors throughout OpenMx.  The "meat" of the sandwich is the covariance
matrix of the numerically computed row derivatives of the likelihood function
(i.e. row gradients).

When \code{details=FALSE}, only the standard errors are returned.  When \code{details=TRUE},
a list with named elements \code{SE} and \code{cov} is returned.  The \code{SE} element is the vector of standard errors that is also returned when \code{details=FALSE}.  The \code{cov} element is the full covariance matrix of the parameter estimates.  The square root of the diagonal of \code{cov} gives the standard errors.

This function may not work correctly if 'model' is a multigroup model.  This function also does not correctly handle multilevel data.
}
