% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagOMLObject.R
\name{tagOMLObject}
\alias{tagOMLObject}
\alias{untagOMLObject}
\title{Tagging of OpenML objects}
\usage{
tagOMLObject(ids, object = c("data", "task", "flow", "run"), tags,
  verbosity = NULL)

untagOMLObject(ids, object = c("data", "task", "flow", "run"), tags,
  verbosity = NULL)
}
\arguments{
\item{ids}{[\code{integer}]\cr
The IDs of the respective objects.}

\item{object}{[\code{character(1)}]\cr
A character that specifies the object you want to delete from the server. Can be either
\code{"data"}, \code{"task"}, \code{"flow"} or \code{"run"}.}

\item{tags}{[\code{character}]\cr
The tags that should be added/removed.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\description{
Add or remove a specific tag to a OpenML data, task, flow or run.
}
\seealso{
Other data set-related functions: \code{\link{OMLDataSetDescription}},
  \code{\link{OMLDataSet}},
  \code{\link{convertMlrTaskToOMLDataSet}},
  \code{\link{convertOMLDataSetToMlr}},
  \code{\link{deleteOMLObject}},
  \code{\link{getOMLDataSet}},
  \code{\link{listOMLDataSets}},
  \code{\link{uploadOMLDataSet}}

Other flow-related functions: \code{\link{convertOMLFlowToMlr}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLFlow}},
  \code{\link{listOMLFlows}},
  \code{\link{makeOMLFlowParameter}},
  \code{\link{makeOMLFlow}}

Other run-related functions: \code{\link{convertOMLMlrRunToBMR}},
  \code{\link{convertOMLRunToBMR}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLRun}},
  \code{\link{listOMLRuns}},
  \code{\link{makeOMLRunParameter}},
  \code{\link{makeOMLRun}}, \code{\link{uploadOMLRun}}

Other task-related functions: \code{\link{convertOMLTaskToMlr}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLTask}},
  \code{\link{listOMLTaskTypes}},
  \code{\link{listOMLTasks}}, \code{\link{makeOMLTask}}
}

