% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hog_features_rscript.R
\name{HOG}
\alias{HOG}
\title{calculate the HOG (Histogram of oriented gradients) for an image}
\usage{
HOG(image, cells = 3, orientations = 6)
}
\arguments{
\item{image}{matrix or 3-dimensional array}

\item{cells}{the number of divisions ( cells )}

\item{orientations}{number of orientation bins}
}
\value{
a numeric vector
}
\description{
The function is a modification of the 'findHOGFeatures' function of the SimpleCV package [ please consult the COPYRIGHT file ]
The function takes either an RGB (it will be converted to gray) or a gray image and returns a vector of the HOG descriptors.
The main purpose of the function is to create a vector of features, which can be used in classification tasks.
}
\details{
This function takes either a matrix, a data frame or a 3-dimensional array and returns a vector with the HOG-descriptors (histogram of oriented gradients).
}
\examples{

\dontrun{

path = system.file("tmp_images", "1.png", package = "OpenImageR")

image = readImage(path)

res = HOG(image, cells = 3, orientations = 6)
}
}
