% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseInObservation.R
\name{summariseInObservation}
\alias{summariseInObservation}
\title{Summarise the number of people in observation during a specific interval of
time.}
\usage{
summariseInObservation(
  observationPeriod,
  interval = "overall",
  output = "record",
  ageGroup = NULL,
  sex = FALSE,
  dateRange = NULL
)
}
\arguments{
\item{observationPeriod}{An observation_period omop table. It must be part of
a cdm_reference object.}

\item{interval}{Time interval to stratify by. It can either be "years", "quarters", "months" or "overall".}

\item{output}{Output format. It can be either the number of records
("record") that are in observation in the specific interval of time, the
number of person-days ("person-days"), the number of subjects ("person"),
the number of females ("sex") or the median age of population in observation ("age").}

\item{ageGroup}{A list of age groups to stratify results by.}

\item{sex}{Boolean variable. Whether to stratify by sex (TRUE) or not
(FALSE). For output = "sex" this stratification is not applied.}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}
}
\value{
A summarised_result object.
}
\description{
Summarise the number of people in observation during a specific interval of
time.
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)

cdm <- mockOmopSketch()

result <- summariseInObservation(
  cdm$observation_period,
  interval = "months",
  output = c("person-days", "record"),
  ageGroup = list("<=60" = c(0, 60), ">60" = c(61, Inf)),
  sex = TRUE
)

result |>
  glimpse()

PatientProfiles::mockDisconnect(cdm)
}
}
