% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableClinicalRecords.R
\name{tableClinicalRecords}
\alias{tableClinicalRecords}
\title{Create a visual table from a summariseClinicalRecord() output.}
\usage{
tableClinicalRecords(result, type = "gt")
}
\arguments{
\item{result}{Output from summariseClinicalRecords().}

\item{type}{Type of formatting output table, either "gt" or "flextable".}
}
\value{
A gt or flextable object with the summarised data.
}
\description{
Create a visual table from a summariseClinicalRecord() output.
}
\examples{
\donttest{
cdm <- mockOmopSketch()

summarisedResult <- summariseClinicalRecords(
  cdm = cdm,
  omopTableName = c("condition_occurrence", "drug_exposure"),
  recordsPerPerson = c("mean", "sd"),
  inObservation = TRUE,
  standardConcept = TRUE,
  sourceVocabulary = TRUE,
  domainId = TRUE,
  typeConcept = TRUE
)

summarisedResult |>
  suppress(minCellCount = 5) |>
  tableClinicalRecords()

PatientProfiles::mockDisconnect(cdm)
}
}
