% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNA_summary_predicted.R
\name{miRNA_summary_predicted}
\alias{miRNA_summary_predicted}
\title{miRNA_summary_predicted}
\usage{
miRNA_summary_predicted(data, type = "class")
}
\arguments{
\item{data}{Requires a  data frame generated by score_genes. Class - data frame}

\item{type}{Requires to specify a value for plotting. If plotting is performed for location select "location", alternatively select "class"; default is "class". Class - string}
}
\value{
a data frame with GC content; multiple plots summarising the data are also provided
}
\description{
miRNA_summary_predicted function provides information on genes that have predicted/inferred miRNA regulating them. The function checks  genes against predicted miRNA target database image and provides various plots to assess emerging data features. The user can also specify if the plotting is necessary for location ("location") or protein class ("class").
}
\examples{
\dontrun{
path_to_test_data<- system.file("extdata", "test_data.tabular", package="OmicInt")
# basic usage of miRNA_summary_predicted
df<-utils::read.table(path_to_test_data)
return_df<-miRNA_summary_predicted(df)
head(return_df)
}
}
