% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_utils.R
\name{olink_norm_input_validate}
\alias{olink_norm_input_validate}
\title{Validate inputs of normalization function}
\usage{
olink_norm_input_validate(
  df1,
  df2,
  overlapping_samples_df1,
  overlapping_samples_df2,
  reference_medians
)
}
\arguments{
\item{df1}{First dataset to be used in normalization (required).}

\item{df2}{Second dataset to be used in normalization.}

\item{overlapping_samples_df1}{Samples to be used for adjustment factor
calculation in df1 (required).}

\item{overlapping_samples_df2}{Samples to be used for adjustment factor
calculation in df2.}

\item{reference_medians}{Dataset with columns "OlinkID" and "Reference_NPX".
Used for reference median normalization.}
}
\value{
Scalar character from \var{olink_norm_modes} if normalization can be
determined from the input, otherwise see details.
}
\description{
This function takes as input some of the inputs of the Olink normalization
function and checks the validity of the input.
}
\details{
Depending on the input the function will return:
\itemize{
\item \strong{Error}: if the required components are lacking from the input
or if the normalization cannot be performed.
\item \strong{Warning}: if the normalization can be determined but extra
inputs are provided. This will be followed by a message and the type of
normalization to be performed.
\item \strong{Message}: Information about the type of
normalization to be performed.
}

\strong{Note} that input are passed directly from the main
\code{\link{olink_normalization}} function.
}
\author{
Klev Diamanti
}
