/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.custom;

import java.util.List;
import org.andwellness.config.grammar.syntaxtree.NodeOptional;
import org.andwellness.config.grammar.syntaxtree.NodeSequence;
import org.andwellness.config.grammar.syntaxtree.NodeToken;
import org.andwellness.config.grammar.syntaxtree.condition;
import org.andwellness.config.grammar.syntaxtree.conjunction;
import org.andwellness.config.grammar.syntaxtree.expr;
import org.andwellness.config.grammar.syntaxtree.id;
import org.andwellness.config.grammar.syntaxtree.sentence;
import org.andwellness.config.grammar.syntaxtree.sentence_prime;
import org.andwellness.config.grammar.syntaxtree.start;
import org.andwellness.config.grammar.syntaxtree.value;
import org.andwellness.config.grammar.visitor.GJDepthFirst;
import org.andwellness.xml.datagenerator.comparator.DataPointComparator;
import org.andwellness.xml.datagenerator.comparator.DataPointComparatorFactory;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.apache.log4j.Logger;

public class ConditionDepthFirst<R, A>
extends GJDepthFirst<R, A> {
    private List<DataPoint> _currentIdList;
    private static Logger _logger = Logger.getLogger(ConditionDepthFirst.class);

    public ConditionDepthFirst(List<DataPoint> currentIdList) {
        this._currentIdList = currentIdList;
    }

    @Override
    public R visit(NodeToken n, A argu) {
        return (R)n.toString();
    }

    @Override
    public R visit(start n, A argu) {
        R _ret = null;
        _ret = n.f0.accept(this, argu);
        n.f1.accept(this, argu);
        return _ret;
    }

    @Override
    public R visit(sentence n, A argu) {
        R _ret = null;
        NodeSequence nodeSequence = (NodeSequence)n.f0.choice;
        if (n.f0.which == 0) {
            expr expressionNode = (expr)nodeSequence.elementAt(0);
            sentence_prime sentencePrimeNode = (sentence_prime)nodeSequence.elementAt(1);
            Boolean exprBool = (Boolean)expressionNode.accept(this, argu);
            _ret = sentencePrimeNode.accept(this, exprBool);
        } else if (n.f0.which == 1) {
            sentence sentenceNode = (sentence)nodeSequence.elementAt(1);
            sentence_prime sentencePrimeNode = (sentence_prime)nodeSequence.elementAt(3);
            Boolean sentenceBool = (Boolean)sentenceNode.accept(this, argu);
            _ret = sentencePrimeNode.accept(this, sentenceBool);
        }
        return _ret;
    }

    @Override
    public R visit(sentence_prime n, A argu) {
        Boolean _ret = null;
        Boolean initialValue = (Boolean)argu;
        NodeOptional nodeOptional = n.f0;
        if (!nodeOptional.present()) {
            _ret = initialValue;
        } else {
            Boolean toPassToSentencePrime;
            NodeSequence nodeSequence = (NodeSequence)nodeOptional.node;
            String conjValue = (String)nodeSequence.elementAt(0).accept(this, argu);
            sentence_prime sentencePrime = (sentence_prime)nodeSequence.elementAt(2);
            if ("and".equals(conjValue)) {
                Boolean sentValue;
                toPassToSentencePrime = !initialValue.booleanValue() ? new Boolean(false) : ((sentValue = (Boolean)nodeSequence.elementAt(1).accept(this, argu)).booleanValue() ? new Boolean(true) : new Boolean(false));
            } else if ("or".equals(conjValue)) {
                Boolean sentValue;
                toPassToSentencePrime = initialValue.booleanValue() ? new Boolean(true) : ((sentValue = (Boolean)nodeSequence.elementAt(1).accept(this, argu)).booleanValue() ? new Boolean(true) : new Boolean(false));
            } else {
                throw new IllegalArgumentException("Conjunction neither and nor or.");
            }
            _ret = sentencePrime.accept(this, toPassToSentencePrime);
        }
        return (R)_ret;
    }

    @Override
    public R visit(expr n, A argu) {
        Boolean _ret = null;
        String nodeId = (String)n.f0.accept(this, argu);
        String nodeCondition = (String)n.f1.accept(this, argu);
        String nodeValue = (String)n.f2.accept(this, argu);
        DataPoint dataPointForComparison = new DataPoint(nodeId);
        int nodeIdLocation = this._currentIdList.indexOf(dataPointForComparison);
        if (nodeIdLocation == -1) {
            _ret = new Boolean(false);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Could not find node id " + nodeId);
            }
        } else {
            DataPoint dataPoint = this._currentIdList.get(nodeIdLocation);
            DataPointComparator dataPointComparator = DataPointComparatorFactory.createDataPointComparator(dataPoint.getPromptType());
            boolean result = dataPointComparator.compare(dataPoint, nodeValue, nodeCondition);
            _ret = new Boolean(result);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Evaluated " + nodeId + " " + nodeCondition + " " + nodeValue + " and got " + _ret.toString());
        }
        return (R)_ret;
    }

    @Override
    public R visit(id n, A argu) {
        R _ret = null;
        _ret = n.f0.accept(this, argu);
        return _ret;
    }

    @Override
    public R visit(condition n, A argu) {
        R _ret = null;
        _ret = n.f0.accept(this, argu);
        return _ret;
    }

    @Override
    public R visit(value n, A argu) {
        R _ret = null;
        _ret = n.f0.accept(this, argu);
        return _ret;
    }

    @Override
    public R visit(conjunction n, A argu) {
        R _ret = null;
        _ret = n.f0.accept(this, argu);
        return _ret;
    }
}

