% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortQueries.R
\name{getCohortSubsetDefinitions}
\alias{getCohortSubsetDefinitions}
\title{Extract the cohort subset definition details}
\usage{
getCohortSubsetDefinitions(
  connectionHandler,
  schema,
  cgTablePrefix = "cg_",
  subsetIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{subsetIds}{A vector of subset cohort ids or NULL}
}
\value{
Returns a data.frame with the cohort subset details
}
\description{
This function extracts all cohort subset definitions for the subsets of interest.
}
\details{
Specify the connectionHandler, the schema and the subset IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

subsetDef <- getCohortSubsetDefinitions(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Cohorts: 
\code{\link{getCohortDefinitions}()},
\code{\link{processCohorts}()}
}
\concept{Cohorts}
