% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionPerformanceTable}
\alias{getPredictionPerformanceTable}
\title{Extract specific results table}
\usage{
getPredictionPerformanceTable(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  table = "attrition",
  performanceId = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{table}{The table to extract}

\item{performanceId}{(optional) restrict to the input performanceId}
}
\value{
Returns a data.frame with the specified table
}
\description{
This function extracts the specified table
}
\details{
Specify the connectionHandler, the resultDatabaseSettings, the table of interest and (optionally) a performanceId to filter to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

attrition <- getPredictionPerformanceTable(
  connectionHandler = connectionHandler, 
  schema = 'main',
  table = 'attrition'
)

}
\seealso{
Other Prediction: 
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
