% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PicoVR.r
\name{opiSetup_for_PicoVR}
\alias{opiSetup_for_PicoVR}
\title{Implementation of opiSetup for the PicoVR machine.}
\arguments{
\item{settings}{A list containing:
\itemize{
\item \code{eye} The eye for which to apply the settings.
\item \code{bgImageFilename} (Optional) If present, display the image in the
background for eye (scaled to fill fov, bgLum and bgCol ignored)
\item \code{fixShape} (Optional) Fixation target type for eye.
\item \code{fixLum} (Optional) Fixation target luminance for eye.
\item \code{fixType} (Optional) Fixation target texture for eye.
\item \code{fixCx} (Optional) x-coordinate of fixation target (degrees).
\item \code{fixCy} (Optional) y-coordinate of fixation target (degrees).
\item \code{fixCol} (Optional) Fixation target color for eye.
\item \code{bgLum} (Optional) Background luminance for eye (cd/m^2).
\item \code{tracking} (Optional) Whether to correct stimulus location based on eye position.
\item \code{bgCol} (Optional) Background color for eye (rgb).
\item \code{fixSx} (Optional) diameter along major axis of ellipse (degrees). 0
to hide fixation marker.
\item \code{fixSy} (Optional) diameter along minor axis of ellipse (degrees). If
not received, then sy = sx.
\item \code{fixRotation} (Optional) Angles of rotation of fixation target
(degrees). Only useful if sx != sy specified.
\item \code{fixImageFilename} (Optional) If fixType == IMAGE, the filename on
the local filesystem of the machine running JOVP of the image to use
}}
}
\value{
A list containing:
\itemize{
\item \code{err} \code{NULL} if there was no error, a string message if there is an error.
}
}
\description{
This is for internal use only. Use \code{\link[=opiSetup]{opiSetup()}} after
\code{chooseOPI("PicoVR")} to call this function.
}
\details{
\code{eye} can take on values in the set \code{{"left", "right", "both",
     "none"}}.

\code{fixShape} can take on values in the set \code{{"triangle",
          "square", "polygon", "hollow_triangle", "hollow_square",
          "hollow_polygon", "cross", "maltese", "circle", "annulus",
          "optotype", "text", "model"}}.

\code{fixLum} can take on values in the range \code{[0.0, 1.0E10]}.

\code{fixType} can take on values in the set \code{{"flat",
         "checkerboard", "sine", "squaresine", "g1", "g2", "g3", "text", "image"}}.

\code{fixCx} can take on values in the range \code{[-90.0, 90.0]}.

\code{fixCy} can take on values in the range \code{[-90.0, 90.0]}.

Elements in \code{fixCol} can take on values in the range \code{[0.0, 1.0]}.

\code{bgLum} can take on values in the range \code{[0.0, 1.0E10]}.

\code{tracking} can take on values in the range \code{[0, 1]}.

Elements in \code{bgCol} can take on values in the range \code{[0.0, 1.0]}.

\code{fixSx} can take on values in the range \code{[0.0, 1.0E10]}.

\code{fixSy} can take on values in the range \code{[0.0, 1.0E10]}.

\code{fixRotation} can take on values in the range \code{[0.0, 360.0]}.
}
\examples{
chooseOpi("PicoVR")
opiInitialise(list(port = 50001, ip = "localhost"))
result <- opiSetup(settings = list(eye = "BOTH"))

}
\seealso{
\code{\link[=opiSetup]{opiSetup()}}
}
