% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opi.r, R/compassClient.r, R/displayClient.r,
%   R/daydreamClient.r, R/imoClient.r, R/kowaAP7000Client.r, R/octopus600.r,
%   R/octopus900Client.r, R/simG.r, R/simH.r, R/simH_RT.r, R/simNo.r, R/simYes.r
\name{opiSetBackground}
\alias{opiSetBackground}
\alias{compass.opiSetBackground}
\alias{display.opiSetBackground}
\alias{daydream.opiSetBackground}
\alias{imo.opiSetBackground}
\alias{kowaAP7000.opiSetBackground}
\alias{octo600.opiSetBackground}
\alias{octo900.opiSetBackground}
\alias{simG.opiSetBackground}
\alias{simH.opiSetBackground}
\alias{simH_RT.opiSetBackground}
\alias{simNo.opiSetBackground}
\alias{simYes.opiSetBackground}
\title{Set background using OPI}
\usage{
opiSetBackground(...)

compass.opiSetBackground(lum = NA, color = NA, fixation = NA, tracking_on = NA)

display.opiSetBackground(
  lum = .OpiEnv$Display$background_lum,
  color = .OpiEnv$Display$background_color,
  fixation = .OpiEnv$Display$fixation,
  fix_cx = .OpiEnv$Display$fix_cx,
  fix_cy = .OpiEnv$Display$fix_cy,
  fix_sx = .OpiEnv$Display$fix_sx,
  fix_sy = .OpiEnv$Display$fix_sy,
  fix_color = .OpiEnv$Display$fix_color
)

daydream.opiSetBackground(
  eye,
  lum = 10,
  color = "white",
  fixation = "None",
  fix_cx = 0,
  fix_cy = 0,
  fix_sx = 2,
  fix_sy = 2,
  fix_color = "green"
)

imo.opiSetBackground(
  bgl = 30,
  tgl = 1,
  tgldb = 25,
  tglx = 0,
  tgly = 0,
  bgr = 30,
  tgr = 1,
  tgrdb = 25,
  tgrx = 0,
  tgry = 0
)

kowaAP7000.opiSetBackground(lum = NA, color = NA, fixation = NA)

octo600.opiSetBackground(
  bgColor = NA,
  fixType = NA,
  fixColor = NA,
  fixIntensity = 255
)

octo900.opiSetBackground(
  lum = NA,
  color = NA,
  fixation = NA,
  fixIntensity = NA
)

simG.opiSetBackground(col, gridCol)

simH.opiSetBackground(col, gridCol)

simH_RT.opiSetBackground(col, gridCol)

simNo.opiSetBackground(col, gridCol)

simYes.opiSetBackground(col, gridCol)
}
\arguments{
\item{...}{Implementation specific parameters. See details.}

\item{lum}{Luminance level in cd/m^2}

\item{color}{Stimulus color}

\item{fixation}{fixation target}

\item{tracking_on}{\code{TRUE} for tracking on, \code{FALSE} for off}

\item{fix_cx}{fixation x position in degrees of visual angle. Default is 0}

\item{fix_cy}{fixation y position in degrees of visual angle. Default is 0}

\item{fix_sx}{fixation horizontal size in degrees of visual angle. Default is 1}

\item{fix_sy}{fixation vertical size in degrees of visual angle. Default is 1}

\item{fix_color}{fixation color}

\item{eye}{eye}

\item{bgl}{left eye background luminance in dB Default is 25}

\item{tgl}{left eye fixation target. Default is 1}

\item{tgldb}{left eye fixation target luminance in dB. Default is 20}

\item{tglx}{left eye fixation target x-position in degrees. Default is 0.}

\item{tgly}{left eye fixation target y-position in degrees. Default is 0.}

\item{bgr}{right eye background luminance in dB. Default is 25}

\item{tgr}{right eye target type. Default is 1}

\item{tgrdb}{right eye target luminance in dB. Default is 20}

\item{tgrx}{right eye fixation target x-position in degrees. Default is 0.}

\item{tgry}{right eye fixation target y-position in degrees. Default is 0.}

\item{bgColor}{Background color}

\item{fixType}{fixation type}

\item{fixColor}{fixation color}

\item{fixIntensity}{fixation point intensity}

\item{col}{DESCRIPTION for OPI implementations based on simulations}

\item{gridCol}{DESCRIPTION for OPI implementation based on simulations}
}
\value{
Returns NULL if succeeded, otherwise an implementation-dependent
error as follows.

\subsection{Compass}{ 
  A list contining \code{error} which is \code{NULL} for success, or some string description for fail.
}

\subsection{Display}{ 
   Changes the background and the fixation marker.
}

\subsection{Daydream}{ 
  DETAILS
}

\subsection{imo}{ 
  DETAILS
}

\subsection{KowaAP7000}{ 
  DETAILS
}

\subsection{Octopus600}{ 
  DETAILS
}

\subsection{Octopus900}{ 
  -1 indicates \code{opiInitialize} has not been called.
  
  -2 indicates could not set the background color.
  
  -3 indicates could not set the fixation marker.
  
  -4 indicates that all input parameters were NA.
}
}
\description{
Generic function for setting background of the chosen OPI
implementation that is set with \code{chooseOpi()}
}
\details{
\subsection{Compass}{
  \code{opiSetBackground(fixation=NA, tracking_on=NA)}
  \itemize{
    \item{\code{fixation}=c(x,y,t)} where
    \itemize{
      \item{\code{x}} is one of -20, -6, -3, 0, 3, 6, 20 degrees.
      \item{\code{y}} is 0 degrees.
      \item{\code{t}} is 0 for a spot fixation marker at \code{c(x,y)}, or 1 for a
        square centred on one of \code{(-3,0)}, \code{(0,0)}, \code{(+3,0)}.
    }
    \item{\code{tracking_on}} is either 0 (tracking off) or 1 (tracking on).
  }
  Note: tracking will be relative to the PRL established with the fixation
  marker used at setup (call to OPI-OPEN), so when tracking is on you should
  use the same fixation location as in the setup.
}

\subsection{Display}{
  \code{opiSetBackground(TODO)}
}

\subsection{Daydream}{
  \code{opiSetBackground(eye, lum=10, color="white", fixation="Cross", fix_cx=0, fix_cy=0, fix_sx=2, fix_sy=2, fix_lum=10, fix_color="green")}
  \itemize{
    \item{\code{lum}} background luminance in cd/\eqn{\mbox{m}^2}{m^2} is set to nearest grey
      value in \code{lut} from \code{opiInitialize}. Default is 10 cd/\eqn{\mbox{m}^2}{m^2}
    \item{\code{color}} color of the background. It can be \code{'white'} (default) or
      \code{'green'}.
    \item{\code{fixation}} can only be \code{'Cross'} at the moment.
    \item{\code{fix_cx}, \code{fix_cy}} fixation (x, y) position in degrees
      of visual angle
    \item{\code{fix_sx}, \code{fix_sy}} dimensions of fixation target in
      degrees of visual angle
    \item{\code{fix_lum}} luminance of the fixation target in cd/\eqn{\mbox{m}^2}{m^2} is set to
      nearest grey value in \code{lut} from \code{opiInitialize}. Default
      is 15 cd/\eqn{\mbox{m}^2}{m^2}
    \item{\code{fix_color}} color of the fixation target. It can be \code{'white'} or
      \code{'green'}  (default).
  }
}

\subsection{imo}{
  DETAILS
}

\subsection{KowaAP7000}{ 
  \code{opiSetBackground(lum, color, fixation)} 

  \code{lum} and \code{color} are dependant for the Kowa AP-7000. A white
  background must be 10 cd/\eqn{\mbox{m}^2}{m^2}, and a yellow background must
  be 100 cd/\eqn{\mbox{m}^2}{m^2}.

  If \code{lum} is 10 and \code{color} is not set, then
  \code{.OpiEnv$KowaAP7000$BACKGROUND_WHITE} is assumed.
  
  If \code{lum} is 100 and \code{color} is not set,
  then \code{.OpiEnv$KowaAP7000$BACKGROUND_YELLOW} is assumed.
  
  If both \code{lum} and \code{color} is set, then \code{lum} is ignored
  (a warning will be generated
  
  if \code{lum} is incompatible with \code{color}).
  
  \code{fixation} is one of
  \itemize{
    \item \code{.OpiEnv$KowaAP7000$FIX_CENTER}, fixation marker in the centre.
    \item \code{.OpiEnv$KowaAP7000$FIX_CENTRE}, fixation marker in the centre.
    \item \code{.OpiEnv$KowaAP7000$FIX_AUX},    fixation marker is ???.
    \item \code{.OpiEnv$KowaAP7000$FIX_MACULA}, fixation marker is a circle(?).
    \item \code{.OpiEnv$KowaAP7000$FIX_AUX_LEFT}, fixation marker is as for AUX
      but only lower left.
  }
}

\subsection{Octopus600}{ 
  This function has no effect.
}

\subsection{Octopus900}{
  \code{opiSetBackground(lum=NA, color=NA, fixation=NA, fixIntensity=NA)} 

  Allowable \code{lum} and \code{color} are defined in the .OpiEnv environment.

  \itemize{
    \item\code{lum} is intensity of the background and can be one of
    \itemize{
      \item \code{.OpiEnv$O900$BG_OFF}, which turns background off.
      \item \code{.OpiEnv$O900$BG_1}, background of 1.27 cd/\eqn{\mbox{m}^2}{m^2}.
      \item \code{.OpiEnv$O900$BG_10}, background of 10 cd/\eqn{\mbox{m}^2}{m^2}.
      \item \code{.OpiEnv$O900$BG_100}, background of 100 cd/\eqn{\mbox{m}^2}{m^2}.
    }
    \item\code{color} can be one of the following choices.
    \itemize{
      \item\code{.OpiEnv$O900$MET_COL_WW} for white-on-white
      \item\code{.OpiEnv$O900$MET_COL_RW} for red-on-white
      \item\code{.OpiEnv$O900$MET_COL_BW} for blue-on-white
      \item\code{.OpiEnv$O900$MET_COL_WY} for white-on-yellow
      \item\code{.OpiEnv$O900$MET_COL_RY} for red-on-yellow
      \item\code{.OpiEnv$O900$MET_COL_BY} for blue-on-yellow
    }
    \item\code{fixation} is one of 
    \itemize{
      \item\code{.OpiEnv$O900$FIX_CENTRE} or \code{.OpiEnv$O900$FIX_CENTER}
      \item\code{.OpiEnv$O900$FIX_CROSS}
      \item\code{.OpiEnv$O900$FIX_RING}
    }
    \item\code{fixIntensity} is a percentage between 0 and 100. 0 is off, 100
      the brightest.
  }
  Note if you specify \code{fixation} you also have to specify \code{fixIntensity}.
}

\subsection{SimGaussian}{
  \code{opiSetBackground(col, gridCol)}
  
  \code{col} is the background color of the plot area used for displaying
  stimuli, and \code{gridCol} the color of the gridlines. Note the plot area
  will only be displayed if \code{opiInitialize} is called with a valid display
  argument.
}

\subsection{SimHenson}{ 
  \code{opiSetBackground(col, gridCol)}
  
  \code{col} is the background color of the plot area used for displaying
  stimuli, and \code{gridCol} the color of the gridlines. Note the plot area
  will only be displayed if \code{opiInitialize} is called with a valid display
  argument.
}

\subsection{SimHensonRT}{
  \code{opiSetBackground(col, gridCol)}
  
  \code{col} is the background color of the plot area used for displaying
  stimuli, and \code{gridCol} the color of the gridlines. Note the plot area
  will only be displayed if \code{opiInitialize} is called with a valid display
  argument.
}

\subsection{SimNo}{
  DETAILS
}

\subsection{SimYes}{
  DETAILS
}
}
\examples{
\dontrun{
  # Set up a Display and wait for a key press in it.
  chooseOpi("Display")
  if (!is.null(opiInitialize(width = 1680, height = 1050, ppi = 128, viewdist = 25)))
    stop("opiInitialize failed")

  opiSetBackground()
  opiSetBackground(lum = 100, color = "white", fixation = "Circle")
  opiSetBackground(lum = 100, color = "white", fixation = "Cross", fix_color = "red",
                   fix_cx = 2, fix_cy = 5, fix_sx = 1, fix_sy = 2)
  opiClose()
}
\dontrun{
  chooseOpi("Octopus900")
  oi <- opiInitialize(eyeSuiteJarLocation="c:/EyeSuite/",
                      eyeSuiteSettingsLocation="c:/Documents and Settings/All Users/Haag-Streit/",
                      eye="left")
  if(!is.null(oi))
    stop("opiInitialize failed")
  if(!is.null(opiSetBackground(fixation=.OpiEnv$O900$FIX_CENTRE)))
    stop("opiSetBackground failed")
  if(!is.null(opiSetBackground(fixation=.OpiEnv$O900$FIX_RING, fixIntensity=0)))
    stop("opiSetBackground failed")
  if(!is.null(opiSetBackground(color=.OpiEnv$O900$MET_COL_BY)))
    stop("opiSetBackground failed")
  if(!is.null(opiSetBackground(lum=.OpiEnv$O900$BG_100, color=.OpiEnv$O900$MET_COL_RW)))
    stop("opiSetBackground failed")
  opiClose()
}
chooseOpi("SimGaussian")
if (!is.null(opiInitialize(sd=2)))
  stop("opiInitialize failed")
if (!is.null(opiSetBackground(col="white",gridCol="grey")))
  stop("opiSetBackground failed, which is very surprising!")
}
\seealso{
\code{\link{chooseOpi}}
}
