% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_chart.R
\name{chart_forecast}
\alias{chart_forecast}
\title{Chart forecasts}
\usage{
chart_forecast(Data, Title, Ylab, Freq, zeroline = FALSE)
}
\arguments{
\item{Data}{data.frame: oos.forecast object}

\item{Title}{string: chart title}

\item{Ylab}{string: y-axis label}

\item{Freq}{string: frequency (acts as sub-title)}

\item{zeroline}{boolean: if TRUE then add a horizontal line at zero}
}
\value{
ggplot2 chart
}
\description{
Chart forecasts
}
\examples{
\donttest{

 # simple time series
 A = c(1:100) + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, A)

 # run forecast_univariate
 forecast.uni =
   forecast_univariate(
     Data = Data,
     forecast.dates = tail(Data$date,10),
     method = c('naive','auto.arima', 'ets'),
     horizon = 1,
     recursive = FALSE,
     freq = 'month')

 forecasts =
   dplyr::left_join(
     forecast.uni,
     data.frame(date, observed = A),
     by = 'date'
   )

 # chart forecasts
 chart.forecast =
   chart_forecast(
     forecasts,
     Title = 'test',
     Ylab = 'Index',
     Freq = 'Monthly',
     zeroline = TRUE)

}

}
