% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/second_hierarchy.R
\name{second_hierarchy}
\alias{second_hierarchy}
\title{Second Hierarchy Clusters}
\usage{
second_hierarchy(
  data,
  Kcluster,
  distHierarchical,
  numKLocal,
  limitSeparationLocal,
  maxDistLocal
)
}
\arguments{
\item{data}{A data frame with four columns:\cr
Initial Latitude | Initial Longitude | Final Latitude | Final Longitude}

\item{Kcluster}{An ODMeans structure, result of function first_hierarchy.}

\item{distHierarchical}{Meter distance threshold between origin and destination to generate new local clusters from a first layer cluster.}

\item{numKLocal}{Initial number of clusters in the first call of k-means in the local hierarchy.}

\item{limitSeparationLocal}{Within cluster distance threshold to determine if a local cluster must be separated into two new clusters.}

\item{maxDistLocal}{Meter distance threshold used to re-estimate centroids in local hierarchy.}
}
\value{
Returns an S3 class object similar to kmeans S3 Class, with eight properties.
}
\description{
Second Hierarchy Clusters
}
\examples{
data(ODMeansTaxiData)
first_hierarchy_data = first_hierarchy(ODMeansTaxiData, 10, 500, 1000)
second_hierarchy_data = second_hierarchy(ODMeansTaxiData, first_hierarchy_data, 2200, 3, 50, 100)
}
