% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dinamic_clusters.R
\name{dinamic_clusters}
\alias{dinamic_clusters}
\title{Dinamic Clusters Function}
\usage{
dinamic_clusters(data, numK, limitsSeparation, maxDist)
}
\arguments{
\item{data}{A data frame with four columns:\cr
Initial Latitude | Initial Longitude | Final Latitude | Final Longitude}

\item{numK}{Initial number of clusters in the first call of K-Means.}

\item{limitsSeparation}{Range to determine if a drastic change has happened between a cluster and its separation.
A bigger value makes more difficult to separate a cluster.}

\item{maxDist}{Maximum distance to join two points. This is based on the euclidean distance.}
}
\value{
Dinamic Clusters returns an object similar of class "kmeans". It is a list with at least the following components:

cluster A vector of integers (from 1:k) indicating the cluster to which each point is allocated.
centers A matrix of cluster centres.
totss The total sum of squares.
withinss Vector of within-cluster sum of squares, one component per cluster.
tot.withinss Total within-cluster sum of squares, i.e. sum(withinss).
betweenss The between-cluster sum of squares, i.e. totss-tot.withinss.
size The number of points in each cluster.
level_hierarchy Corresponds of the hierarchy level of the cluster, can be "Global" or "Local"
}
\description{
Dinamic Clusters Function
}
\examples{
data(ODMeansSampleData)
dinamic_clusters(ODMeansSampleData, 5, 200, 2500)
}
