\name{draw_subcatchments_OCN}
\alias{draw_subcatchments_OCN}
\title{Draw subcatchment map from an Optimal Channel Network}
\usage{
draw_subcatchments_OCN(OCN, theme = NULL, drawRiver = TRUE,
 colPalette = NULL, colLevels = NULL, riverColor = NULL, addLegend = NULL, 
 min_lwd = 0.5, max_lwd = 5, ...)
}
\arguments{
\item{OCN}{List as produced by \code{\link{aggregate_OCN}}.}

\item{theme}{Vector (of length \code{OCN$SC$Nnodes} expressing the spatial field of interest. }

\item{drawRiver}{Logical. If \code{TRUE}, draw the OCN on top of the subcatchment map.}

\item{colPalette}{Color palette used. \code{colPalette} accepts both functions creating color palettes and vectors of colors. In the latter case, \code{length(colPalette)} must be greater than the number of color levels. If \code{theme = NULL}, default is \code{c("#009900", "#FFFF00",  "#FF9900", "#FF0000", "#FF00FF",  "#9900CC", "#555555", "#BBBBBB")}. Only the first \code{n} colors are used, where \code{n} is the number of different colors needed (calculated via a greedy coloring algorithm). \code{colPalette} accepts both functions creating color palettes and vectors of colors (see examples); in the latter case, the length of the vector cannot be lower than \code{n} (\code{n} cannot be predicted a priori, but generally 6 colors should suffice). If \code{theme != NULL}, default is \code{colorRampPalette(c("yellow","red","black"))}. }

\item{colLevels}{Number of colors in the palette (only effective if \code{theme} is not null). \code{colLevels} must be a vector of the form \code{c(minval, maxval)} or \code{c(minval, maxval, N_levels)}. The vector of breakpoints used to attribute \code{theme} values to a given color is then defined as \code{seq(minval, maxval, N_levels)}. Default is \code{minval = min(theme[!(is.nan(theme))])}, \code{maxval = max(theme[!(is.nan(theme))])}, \code{N_levels = 1000}.} 

\item{riverColor}{Color used to display the OCN (only effective if \code{drawRiver = TRUE}). }

\item{addLegend}{Logical. State if a legend should be displayed (only active if \code{theme} is not null.}

\item{min_lwd, max_lwd}{Minimum and maximum values of line width used to display the OCN (actual line width is proportional to the square root of drainage area).}

\item{...}{Further arguments to be passed to \code{plot}. Default plot options are as in \code{draw_thematic_OCN}.}
}
\value{
No output is returned.
}
\description{
Function that draws a map of subcatchments generated by the aggregation process on the OCN. If \code{theme} is \code{NULL}, colormap is such that neighbouring subcatchments have distinguished colors. If \code{theme} is specified, colors reflect the values of \code{theme} across subcatchments, in analogy with \code{draw_thematic_OCN}.
}
\seealso{
\code{\link{draw_thematic_OCN}}
}
\examples{
# 1a) aggregate a 20x20 OCN , use thrA = 5 pixels
# and draw subcatchments with default color palette
OCN <- aggregate_OCN(landscape_OCN(OCN_20), thrA = 5)
draw_subcatchments_OCN(OCN, drawRiver = TRUE)

# 1b) same as above, but define color palette with a function
draw_subcatchments_OCN(OCN, drawRiver = TRUE, colPalette = rainbow)

# 1c) same as above, but define color palette with a vector of colors
draw_subcatchments_OCN(OCN, drawRiver = TRUE, colPalette = hcl.colors(6, "Dark 3"))

# 2) Display theme at subcatchment level
draw_subcatchments_OCN(OCN, theme = OCN$AG$A)
}
