% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.OBREresult.R
\name{summary.OBREresult}
\alias{summary.OBREresult}
\title{Function that summarize the results contained in an OBREresult object.}
\usage{
\method{summary}{OBREresult}(object)
}
\arguments{
\item{object}{The OBREresult object (output of OBRE function) that has to be plotted.}
}
\value{
The summary an OBREresult obect with the estimated parameters, the OBRE tuning parameter,
the proportion of data weighted and the relative efficiency with respect to MLE.
}
\description{
The function shows the estimated parameters, the OBRE tuning parameter,
the proportion of data weighted and the relative efficiency with respect to MLE of an OBREresult object.
}
\examples{
\donttest{# Generates the Normal distribution input for OBRE
distrForOBRE <- densityExpressions(strDistribution = "normal")
# Generates input data
simData = c(rnorm(100, 12, 1), rnorm(10, 10, 10))
# Estimates OBREresult object
estOBRE <- OBRE(nvData = simData, strDistribution = distrForOBRE, nCParOBRE = 3)
# Summary of the results
summary(estOBRE)}

}

