% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OBRECovarianceMatrix.R
\name{OBRECovarianceMatrix}
\alias{OBRECovarianceMatrix}
\title{Function that computes the OBRE covariance matrix.}
\usage{
OBRECovarianceMatrix(lOBRE)
}
\arguments{
\item{lOBRE}{List of all the variables resulting from the OBRE computation.}
}
\value{
A list containing Jacobian of the estimate function, variability and asymptotic covariance
matrices, as well as the relative efficiency with respect to Maximum Likelihood Estimator
}
\description{
The function computes matrices M (Jacobian) and Q (Variability) and
uses them to evaluate the covariance matrix V.
}
\examples{
\donttest{distrForOBRE <- densityExpressions(strDistribution = "normal")
simData = c(rnorm(1000, 12, 2),200,150)
estOBRE <- OBRE(nvData = simData, strDistribution = distrForOBRE, nCParOBRE = 3)
lOBRECov = OBRECovarianceMatrix(estOBRE)}

}
\references{
Hampel, F., Ronchetti, E., Rousseeuw, P. & Stahel, W. (1985). Robust Statistics. The approach based on influence function. John Wiley and Sons Ltd., Chichester, UK.

Heritier S, Cantoni E, Copt S, Victoria-Feser M (2011). Robust Methods in Biostatistics. John Wiley and Sons Ltd., Chichester, UK.
}

