% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterretention.R
\name{pF_curve}
\alias{pF_curve}
\title{Water retention curve}
\usage{
pF_curve(head, thetaR, thetaS, alfa, n)
}
\arguments{
\item{head}{(numeric)  suction pressure ([L] or cm of water)}

\item{thetaR}{(numeric) residual water content (cm3/cm3)}

\item{thetaS}{(numeric) saturated water content (cm3/cm3)}

\item{alfa}{(numeric)  related to the inverse of the air entry suction, alfa > 0 (1/cm)}

\item{n}{(numeric)  a measure of the pore-size distribution, n>1, dimensionless}
}
\value{
theta (numeric) water content (cm3/cm3)

The moisture content of a soil given a certain pressure head. A numeric value.
}
\description{
This function compute water content at given pressure head, using Van Genuchten water retention curve
}
\examples{
pF_curve(head = 2.2, thetaR = 0.01, thetaS = 0.35, alfa = 0.3,n = 1.6)
pF_curve(head = 4.2, thetaR = 0.01, thetaS = 0.35, alfa = 0.3,n = 1.6)

}
