% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sulfur.R, R/sulpher.R
\name{calc_slv}
\alias{calc_slv}
\title{Calculate the SLV}
\usage{
calc_slv(B_LU_BRP, B_SOILTYPE_AGR, B_AER_CBS, A_SOM_LOI, A_S_RT, D_BDS)

calc_slv(B_LU_BRP, B_SOILTYPE_AGR, B_AER_CBS, A_SOM_LOI, A_S_RT, D_BDS)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The type of soil}

\item{B_AER_CBS}{(character) The agricultural economic region in the Netherlands (CBS, 2016)}

\item{A_SOM_LOI}{(numeric) The organic matter content of the soil (in percent)}

\item{A_S_RT}{(numeric) The total Sulfur content of the soil (in mg S per kg)}

\item{D_BDS}{(numeric) The bulk density of the soil (in kg per m3)}
}
\value{
The capacity of the soil to supply Sulfur (kg S / ha / yr). A numeric value.

The capacity of the soil to supply Sulfur (kg S / ha / yr). A numeric value.
}
\description{
This function calculates a S-balance given the SLV (Sulfur supplying capacity) of a soil

This function calculates a S-balance given the SLV (Sulfur supplying capacity) of a soil
}
\examples{
calc_slv(B_LU_BRP = 1019, B_SOILTYPE_AGR = 'dekzand', 
B_AER_CBS = 'Rivierengebied',A_SOM_LOI = 3.5,A_S_RT = 3500, D_BDS = 1400)
calc_slv(1019, 'dekzand', 'Rivierengebied',3.5,3500,1400)
calc_slv(c(256,1019), rep('dekzand',2), rep('Rivierengebied',2),c(6.5,3.5),
c(3500,7500),c(1400,1100))

calc_slv(B_LU_BRP = 1019, B_SOILTYPE_AGR = 'dekzand', 
B_AER_CBS = 'Rivierengebied',A_SOM_LOI = 3.5,A_S_RT = 3500, D_BDS = 1400)
calc_slv(1019, 'dekzand', 'Rivierengebied',3.5,3500,1400)
calc_slv(c(256,1019), rep('dekzand',2), rep('Rivierengebied',2),c(6.5,3.5),
c(3500,7500),c(1400,1100))

}
