% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bodemconditiescore.R
\name{calc_bcs}
\alias{calc_bcs}
\title{Calculate the BodemConditieScore}
\usage{
calc_bcs(
  B_LU_BRP,
  B_SOILTYPE_AGR,
  A_SOM_LOI,
  D_PH_DELTA,
  A_EW_BCS = NA,
  A_SC_BCS = NA,
  A_GS_BCS = NA,
  A_P_BCS = NA,
  A_C_BCS = NA,
  A_RT_BCS = NA,
  A_RD_BCS = NA,
  A_SS_BCS = NA,
  A_CC_BCS = NA,
  type = "score"
)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{A_SOM_LOI}{(numeric) The percentage organic matter in the soil (\%)}

\item{D_PH_DELTA}{(numeric) The pH difference with the optimal pH.}

\item{A_EW_BCS}{(numeric) The presence of earth worms (score 0-1-2)}

\item{A_SC_BCS}{(numeric) The presence of compaction of subsoil (score 0-1-2)}

\item{A_GS_BCS}{(numeric) The presence of waterlogged conditions, gley spots (score 0-1-2)}

\item{A_P_BCS}{(numeric) The presence / occurrence of water puddles on the land, ponding (score 0-1-2)}

\item{A_C_BCS}{(numeric) The presence of visible cracks in the top layer (score 0-1-2)}

\item{A_RT_BCS}{(numeric) The presence of visible tracks / rutting or trampling on the land (score 0-1-2)}

\item{A_RD_BCS}{(integer) The rooting depth (score 0-1-2)}

\item{A_SS_BCS}{(integer) The soil structure (score 0-1-2)}

\item{A_CC_BCS}{(integer) The crop cover on the surface (score 0-1-2)}

\item{type}{(character) Define output of the function. Options: score (integrated score) and indicator (score per indicator)}
}
\value{
A visual soil assessment score derived from field observations driven by organic matter content and soil structure properties. Returns a numeric value.
}
\description{
This function calculates the BodemConditieScore given input from manual observations made in the field.
The individual parameters are scored in three classes: poor (0), neutral (1) or good (2)
More information on this test can be found \href{https://mijnbodemconditie.nl/}{here}
}
\examples{
calc_bcs(B_LU_BRP = 265, B_SOILTYPE_AGR = 'dekzand', A_SOM_LOI = 3.5, D_PH_DELTA = 0.4,
A_EW_BCS = 1, A_SC_BCS = 1, A_GS_BCS = 1, A_P_BCS = 1, A_C_BCS = 1, A_RT_BCS =1, A_RD_BCS = 1, 
A_SS_BCS = 1, A_CC_BCS = 1)

}
\references{
\href{https://mijnbodemconditie.nl/}{mijnbodemconditie.nl}
}
