% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LNV_1998_unit_root.R
\name{LNV_1998_unit_root}
\alias{LNV_1998_unit_root}
\title{Leybourne Newbold and Vougas (1998) nonlinear unit root test function}
\usage{
LNV_1998_unit_root(x, model, max_lags, lsm)
}
\arguments{
\item{x}{series name,}

\item{model}{if model with intercept 1, if model with trend 2 if model with trend*function 3,}

\item{max_lags}{maximum lag}

\item{lsm}{lag selection methods if 1 AIC, if 2 BIC}
}
\value{
"Model" Estimated model

"Selected Lag" the lag order

"Test Statistic" the value of the test statistic
}
\description{
This function allows you to make Leybourne, Newbold and Vougas (1998) nonlinear unit root test
}
\examples{
\donttest{
x <- rnorm(1000)
LNV_1998_unit_root(x, model = 1, max_lags = 6, lsm = 2)


y <- cumsum(rnorm(1000))
LNV_1998_unit_root(y, 3,  3, lsm = 1)


data(IBM)
LNV_1998_unit_root(x = IBM, model=2,max_lags = 10, lsm = 1)

}

}
\references{
Leybourne, S., Newbold, P., & Vougas, D. (1998). Unit roots and smooth transitions. Journal of time series analysis, 19(1), 83-97.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
