% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterMethods.R
\name{summary.filter}
\alias{summary.filter}
\title{Summary method for class filter}
\usage{
\method{summary}{filter}(object, ..., explicit = FALSE)
}
\arguments{
\item{object}{Object of class \code{filter}.}

\item{...}{Additional arguments affecting the summary produced.}

\item{explicit}{If set to \code{TRUE}, the indexes for removed and repaired
instances (as well as new labels for the latters) are displayed. It defaults
to \code{FALSE}.}
}
\description{
This methods allows for appropriately displaying the most important
information about a filtered dataset, contained in the S3 class \code{filter}.
}
\details{
The information offered is the following:
\itemize{
   \item Names of the dataset and the filter.
   \item Original call to the filter.
   \item Specific parameters used for the filter.
   \item Results: number of removed and repaired instances (absolute
   number and percentage).
   \item Additional information (if available, it depends on the filter).
   \item Optionally, if \code{explicit=TRUE}, the indexes for removed and
   repaired instances, as well as the new labels.
}
}
\examples{
# Next example is not run in order to save time
\dontrun{
# Example of filter with additional information available.
data(iris)
out <- edgeBoostFilter(Species~., data = iris)
class(out)
summary(out)
summary(out, explicit = TRUE)
}
}

