% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-misc.R
\name{keep_if_in}
\alias{keep_if_in}
\alias{\%if_in\%}
\title{Keep elements present in x and not contained in y}
\usage{
keep_if_in(x, y)

x \%if_in\% y
}
\arguments{
\item{x}{Source vector.}

\item{y}{Destination vector (of the same mode as x).}
}
\value{
A filtered version of x.
}
\description{
Unlike \code{\link[base:sets]{intersect}}, it does not remove duplicates in
  x and keeps its order.
}
\examples{
keep_if_in(1:5, 3:6)
# returns [3, 4, 5]

keep_if_in(c(4, 3, 4, 3, 1), 3:6)
# returns [4 3 4 3]

}
\seealso{
\code{\link{keep_if_not_in}}
}
