% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purrr-misc.R
\name{keep_at}
\alias{keep_at}
\alias{discard_at}
\title{Keep or discard elements}
\usage{
keep_at(.x, .at)

discard_at(.x, .at)
}
\arguments{
\item{.x}{A list or a vector.}

\item{.at}{A character vector (names), a numeric vector (positions),
a symbol or or a list generated by 
\code{\link[tidyselect:select_helpers]{tidyselect}} 
select helpers.}
}
\value{
A list or a vector.
}
\description{
\code{keep_at()} keeps only the elements from specific positions
  while \code{discard_at()} does the opposite.
  The functions are wrappers around \code{purrr::keep} and
  \code{purrr::discard}, respectively.
}
\examples{
x <- c("First" = 1, "Second" = 2, "Last" = 3)
keep_at(x, "Second")
keep_at(x, Second)
keep_at(x, 2)
keep_at(x, starts_with("Sec"))
#> Second 
#>      2

keep_at(x, ends_with("t"))
#> First  Last 
#>     1     3

x <- c(1, 2, 3)
discard_at(x, 1)
#> Second   Last 
#>      2      3

}
\seealso{
\code{\link[purrr:keep]{purrr::keep}}
}
