% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_packages.R
\name{generate_install_file}
\alias{generate_install_file}
\title{Generates an R file to install packages used by the project.}
\usage{
generate_install_file(file, package_df = get_packages(),
  include_core_package = FALSE)
}
\arguments{
\item{file}{The name of the file to be created.}

\item{package_df}{A data frame obtained with \code{get_packages} that 
contains information regarding the name, version and source of the package.}

\item{include_core_package}{Logical, whether to include in the 
generated install file package which come with R by default}
}
\value{
Nothing
}
\description{
The function takes the output of \code{get_packages} and
  writes in a file the commands needed to install and update
  package used throughout the project.
}
\examples{
\dontrun{
package_df <- get_packages(package_options = c("library"))
generate_install_file("install_packages.R", package_df)
}

}
\seealso{
\code{\link{get_packages}}
}
