% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{other}
\alias{other}
\alias{other,matrix,matrix-method}
\title{Others}
\usage{
other(agents, except)

\S4method{other}{matrix,matrix}(agents, except)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates, or

              \code{AgentMatrix} object representing the moving \code{agents}.}

\item{except}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates, or

              \code{AgentMatrix} object representing the moving \code{agents}.}
}
\value{
Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
        column \code{pycor} representing the \code{patches} in \code{agents} without
        the ones in \code{except}, or

        \code{AgentMatrix} representing the \code{turtles} in \code{agents} without
        the ones in \code{except}.
}
\description{
Report an \code{agentset} of the \code{agents} except specific ones.
}
\details{
Both \code{agents} and \code{except} must be of the same class (e.g., both
         \code{patches} or both \code{turtles}).

         Warning: this function removes \code{turtles} only based on similar \code{who} numbers
         and \code{breed} names.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
p1 <- other(agents = patches(w1), except = patch(w1, 0, 0))
NLcount(p1) # 99 patches

# Turtles
t1 <- createTurtles(n = 10, coords = cbind(xcor = 0, ycor = 0))
t2 <- other(agents = t1, except = turtle(t1, who = 0))
NLcount(t2) # 9 turtles


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#other}
}
\author{
Sarah Bauduin
}
