% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{createTurtles}
\alias{createTurtles}
\alias{createTurtles,numeric,matrix,missing-method}
\alias{createTurtles,numeric,missing,ANY-method}
\title{Create turtles}
\usage{
createTurtles(n, coords, world, heading, breed, color)

\S4method{createTurtles}{numeric,matrix,missing}(n, coords, world, heading,
  breed, color)

\S4method{createTurtles}{numeric,missing,ANY}(n, coords, world, heading,
  breed, color)
}
\arguments{
\item{n}{Integer.}

\item{coords}{Matrix (ncol = 2) with the first column \code{xcor} and the second
column \code{ycor} representing the turtles initial locations.
\code{nrow(coords)} must be equal to 1 or to \code{n}.
Given coordinates must be inside the \code{world}'s extent. If missing,
turtles are put in the center of the \code{world}.}

\item{world}{WorldMatrix or worldArray object.}

\item{heading}{Numeric. Vector of values between 0 and 360. Must be of length 1 or
of length \code{n}. If missing, a random heading is assigned to
each turtle.}

\item{breed}{Character. Vector of "breed" names. Must be of length 1 or of length
\code{n}. If missing, \code{breed = "turtle"} for all turtles.}

\item{color}{Character. Vector of color names. Must be of length \code{n}.
If missing, colors are assigned using the function \code{rainbow(n)}.}
}
\value{
AgentMatrix object of length \code{n} with data for the
        turtles being: "xcor", "ycor", "who", "heading", "prevX", "prevY",
        "breed", and "color".
}
\description{
Create \code{n} moving agents with a set of defined variables.
}
\details{
If \code{coords} is provided, \code{world} must not be provided.

         The identity of the turtles is defined by their "who" number. This
         numbering starts at 0 and increments by 1.

         The coordinates from the previous time step are stored in "prevX" and
         "prevY". The initial values are \code{NA}.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = runif(25))
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#create-turtles}
}
\author{
Sarah Bauduin
}
