% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{minOneOf}
\alias{minOneOf}
\alias{minOneOf,matrix,worldMatrix,missing-method}
\alias{minOneOf,matrix,worldArray,character-method}
\alias{minOneOf,agentMatrix,missing,character-method}
\title{One agent with minimum}
\usage{
minOneOf(agents, world, var)

\S4method{minOneOf}{matrix,worldMatrix,missing}(agents, world)

\S4method{minOneOf}{matrix,worldArray,character}(agents, world, var)

\S4method{minOneOf}{agentMatrix,missing,character}(agents, var)
}
\arguments{
\item{agents}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              AgentMatrix object representing the moving agents.}

\item{world}{WorldMatrix or worldArray object.}

\item{var}{Character. The name of the selected \code{agents} variable.
If \code{agents} are patches and the \code{world} is a
worldMatrix object, \code{var} must not be provided. If
\code{agents} are patches and the \code{world} is a worldArray
object, \code{var} is the name of the layer to use to define the patches
values. If \code{agents} are turtles, \code{var} is one of
the turtles' variable and can be equal to \code{"xcor"},
\code{"ycor"}, any of the variables created when turtles were created,
as well as any variable created using \code{turtlesOwn()}.}
}
\value{
Matrix (ncol = 2, nrow = 1) with the first column "pxcor" and
        the second column "pycor" representing the coordinates of the patch
        (or of one of the patches) among the \code{agents} which has its variable
        equals to the minimum value
        among the \code{agents}, or

        AgentMatrix of length 1 representing the turtle (or one of
        the turtles) among the \code{agents} which has its variable \code{var}
        equals to the minimum value
        among the \code{agents}.
}
\description{
Report one patch or one turtle among \code{agents} which has its variable equals
to the minimum value.
}
\details{
\code{world} must not be provided if \code{agents} are turtles.

         If there are several patches or turtles among \code{agents} with their
         variable equal to the minimum
         value, one is chosen randomly. To access to all patches or turtles among
         \code{agents} which have their variable equal
         to the minimum value, use \code{withMin()}.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = sample(1:5, size = 25, replace = TRUE))
plot(w1)
p1 <- minOneOf(agents = patches(w1), world = w1)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10),
                    heading = sample(1:3, size = 10, replace= TRUE))
t2 <- minOneOf(agents = t1, var = "heading")


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#min-one-of}
}
\author{
Sarah Bauduin
}
