% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{spdf2turtles}
\alias{spdf2turtles}
\alias{spdf2turtles,SpatialPointsDataFrame-method}
\title{From \code{SpatialPointsDataFrame} to \code{agentMatrix}}
\usage{
spdf2turtles(spdf)

\S4method{spdf2turtles}{SpatialPointsDataFrame}(spdf)
}
\arguments{
\item{spdf}{\code{SpatialPointsDataFrame} object representing moving \code{agents}.}
}
\value{
\code{AgentMatrix} object representing the moving \code{agents} (coordinates and data)
as contained in \code{spdf}.
}
\description{
Convert a \code{SpatialPointsDataFrame} object into an \code{agentMatrix} object.
}
\details{
If the \code{spdf} does not contain the variables created with
\code{createTurtles()}, these variables will be created with the
default values as in \code{createTurtles()}.
}
\examples{
sp1 <- SpatialPointsDataFrame(coords = cbind(x = c(1, 2, 3), y = c(1, 2, 3)),
                              data = cbind.data.frame(age = c(0, 0, 3),
                                                      sex = c("F", "F", "M")))
t1 <- spdf2turtles(spdf = sp1)


}
\author{
Sarah Bauduin
}
