% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{layoutCircle}
\alias{layoutCircle}
\alias{layoutCircle,worldNLR,agentMatrix,numeric-method}
\title{Layout turtles on a circle}
\usage{
layoutCircle(world, turtles, radius, torus = FALSE)

\S4method{layoutCircle}{worldNLR,agentMatrix,numeric}(world, turtles, radius,
  torus = FALSE)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{turtles}{AgentMatrix object representing the moving agents.}

\item{radius}{Numeric. Radius of the circle.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
AgentMatrix representing the \code{turtles} with updated
        coordinates and updated data for their "heading" values and
        previous coordinates "prevX"
        and "prevY".
}
\description{
Relocate the \code{turtles} on a circle centered on the \code{world}.
}
\details{
The \code{turtles} point outwards.

         If the
         \code{radius} value leads turtles outside of the \code{world}'s extent
         and \code{torus = TRUE}, they are
         relocated on the other sides of the \code{world}, inside its extent; if
         \code{torus = FALSE}, the turtles are located past
         the world's extent.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9,
                          data = runif(100))
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
plot(w1)
points(t1, col = "black", pch = 16)

t1 <- layoutCircle(world = w1, turtles = t1, radius = 3)
points(t1, col = "red", pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#layout-circle}
}
\author{
Sarah Bauduin
}
