% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_summary_graph.R
\name{network.summary.graph}
\alias{network.summary.graph}
\title{Returns all kinds of graph-level network measures for the netfacs network}
\usage{
network.summary.graph(netfacs.net)
}
\arguments{
\item{netfacs.net}{igraph network object resulting from netfacs.network() function}
}
\value{
Function returns a dataframe with the number of elements in the graph, the number of connected edges, mean strength of connections, transitivity (mean number of closed triads), diameter (furthest path between two elements), degree centralization, and mean distance between elements
}
\description{
Calculates graph level summary measures from the network object
}
\examples{
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

anger.net <- netfacs.network(
  netfacs.data = angry.face,
  link = "unweighted",
  significance = 0.01,
  min.count = 1,
  min.prob = 0,
  min.specificity = 0,
  ignore.element = NULL
)

network.summary.graph(anger.net)
}
