% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_summary.R
\name{network.summary}
\alias{network.summary}
\title{Returns all kinds of network measures for the netfacs network}
\usage{
network.summary(netfacs.graph)
}
\arguments{
\item{netfacs.graph}{igraph network object resulting from netfacs.network() function}
}
\value{
Function returns a data frame with the element, its 'strength' (mean probability of co-occurrence), 'eigenvector' centrality (connection to other highly connected elements), 'betweenness' centrality (number of connections running through the element), and a number of other network measures
}
\description{
Calculates node level centrality measures from the network object
}
\examples{
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

anger.net <- netfacs.network(
  netfacs.data = angry.face,
  link = "unweighted",
  significance = 0.01,
  min.count = 1,
  min.prob = 0,
  min.specificity = 0,
  ignore.element = NULL
)

network.summary(anger.net)
}
