% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_plot.R
\name{network.plot}
\alias{network.plot}
\title{Plots a network object}
\usage{
network.plot(
  netfacs.graph,
  title = "network",
  clusters = TRUE,
  plot.bubbles = FALSE,
  hide_unconnected = TRUE
)
}
\arguments{
\item{netfacs.graph}{igraph network object resulting from
\code{\link{netfacs.network}}}

\item{title}{string of the graph's main title}

\item{clusters}{if \code{TRUE}, \code{\link[igraph]{cluster_fast_greedy}} is
used to establish possible clusters in the dataset}

\item{plot.bubbles}{if TRUE, then the nodes in the network plots will be surrounded by bubbles; if FALSE, the edges connect the names directly}

\item{hide_unconnected}{if TRUE, then the nodes that do not have any significant connections will be hidden in the plot}
}
\value{
Function returns a ggnet plot of the network, where the size of nodes
indicates how often they occur on their own, and edges indicate significant
co-occurrance between them
}
\description{
Plots the network created using the \code{\link{netfacs.network}} function;
for networks with clear clusterin of elements, clusters can get different
colours
}
\examples{
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

anger.net <- netfacs.network(
  netfacs.data = angry.face,
  link = "unweighted",
  significance = 0.01,
  min.count = 1,
  min.prob = 0,
  min.specificity = 0,
  ignore.element = NULL
)

anger.plot <- network.plot(anger.net,
  title = "Angry Faces",
  clusters = FALSE,
  plot.bubbles = TRUE
)
}
