% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{SMC.Smooth}
\alias{SMC.Smooth}
\title{Generic Sequential Monte Carlo Smoothing with Marginal Weights}
\usage{
SMC.Smooth(SISstep, SISstep.Smooth, nobs, yy, mm, par, xx.init, xdim, ydim,
  resample.sch, funH = identity)
}
\arguments{
\item{SISstep}{a function that performs one propagation step using a proposal distribution.
Its input includes \code{(mm,xx,logww,yyy,par,xdim,ydim)}, where
\code{xx} and \code{logww} are the last iteration samples and log weight. \code{yyy} is the
observation at current time step. It should return {xx} (the samples xt) and
{logww} (their corresponding log weight).}

\item{SISstep.Smooth}{the function for backward smoothing step.}

\item{nobs}{the number of observations \code{T}.}

\item{yy}{the observations with \code{T} columns and \code{ydim} rows.}

\item{mm}{the Monte Carlo sample size \code{m}.}

\item{par}{a list of parameter values.}

\item{xx.init}{the initial samples of \code{x_0}.}

\item{xdim}{the dimension of the state variable \code{x_t}.}

\item{ydim}{the dimension of the observation \code{y_t}.}

\item{resample.sch}{a binary vector of length \code{nobs}, reflecting the resampling schedule. resample.sch[i]= 1 indicating resample should be carried out at step \code{i}.}

\item{funH}{a user supplied function \code{h()} for estimation \code{E(h(x_t) | y_1,...,y_T}). Default
is identity for estimating the mean. The function should be able to take vector or matrix as input and operates on each element of the input.}
}
\value{
The function returns the smoothed values.
}
\description{
Generic sequential Monte Carlo smoothing with marginal weights.
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
