% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{ACMx}
\alias{ACMx}
\title{Estimation of Autoregressive Condtional Mean Models}
\usage{
ACMx(y, order = c(1, 1), X = NULL, cond.dist = "po", ini = NULL)
}
\arguments{
\item{y}{time series of counts.}

\item{order}{the order of ACM model.}

\item{X}{matrix of exogenous variables.}

\item{cond.dist}{conditional distributions. "po" for Poisson, "nb" for negative binomial, "dp" for double Poisson.}

\item{ini}{initial parameter estimates designed for use in "nb" and "dp".}
}
\value{
ACMx returns a list with components:
\item{data}{time series.}
\item{X}{matrix of exogenous variables.}
\item{estimates}{estimated values.}
\item{residuals}{residuals.}
\item{sresi}{standardized residuals.}
}
\description{
Estimation of autoregressive conditionl mean models with exogeneous variables.
}
\examples{
X=matrix(rnorm(100,100,1))
y=rpois(100,10)
ACMx(y,c(1,1),X,"po")
}
