% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mvnpdfC}
\alias{mvnpdfC}
\title{C++ implementation of multivariate normal probability density function for 
multiple inputs}
\usage{
mvnpdfC(x, mean, varcovM, Log = TRUE)
}
\arguments{
\item{x}{data matrix}

\item{mean}{mean vector}

\item{varcovM}{variance covariance matrix}

\item{Log}{logical flag for returning the log of the probability density
function. Defaults is \code{TRUE}}
}
\value{
vector of densities
}
\description{
Based on the implementation from Nino Hardt and Dicko Ahmadou
\url{http://gallery.rcpp.org/articles/dmvnorm_arma/}
(accessed in August 2014)
}
\examples{
mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE)
mvnpdfC(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE)
mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1))
mvnpdfC(x=matrix(1.96), mean=0, varcovM=diag(1))

if(require(microbenchmark)){
library(microbenchmark)
microbenchmark(dnorm(1.96),
               mvnpdf(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE),
               mvnpdfC(x=matrix(1.96), mean=0, varcovM=diag(1), Log=FALSE),
               times=10000L)
}else{
cat("package 'microbenchmark' not available\n")
}

}
\author{
Boris P. Hejblum
}
