% Generated by roxygen2 (4.0.2): do not edit by hand
\name{nps}
\alias{nps}
\title{Calculate a Net Promoter Score}
\usage{
nps(x, breaks = list(0:6, 7:8, 9:10))
}
\arguments{
\item{x}{A vector of \emph{Recommend} scores}

\item{breaks}{A \code{list} of length three, giving the integer Likert scale points for \emph{Detractors}, \emph{Passives}, and \emph{Promoters}, respectively. The default is \code{list(0:6, 7:8, 9:10)}}
}
\value{
a Net Promoter Score. Unrounded.
}
\description{
This function calculates a Net Promoter Score from a vector of \emph{Recommend} scores, ideally \code{\link{numeric}} ones. An attempt will be made to coerce \code{\link{factor}}, or \code{\link{character}} data. \code{NA} values, either in the data, or generated by type coercion, are automatically omitted from the calculation. No warning is given in the former case. Net Promoter Scores generated are on a [-1,1] scale; you may want to multiply them by 100 (and perhaps round them!) prior to presentation.
}
\examples{
# This will generate 1000 dummy Likelihood to Recommend reponses
x <- sample(0:10, prob=c(0.02, 0.01, 0.01, 0.01, 0.01, 0.03, 0.03, 0.09,
    0.22, 0.22, 0.35), 1000, replace=TRUE)

# Here are the proportions of respondents giving each Likelihood to
# Recommend response
prop.table(table(x))

# Here's a histrogram of the scores
hist(x, breaks=-1:10, col=c(rep("red",7), rep("yellow",2), rep("green", 2)))

# Here's a barplot. It's very similar, though for categorical responses
# it's often slightly easier to interpret.
barplot(
    prop.table(table(x)),
     col=c(rep("red",7), rep("yellow",2), rep("green", 2))
     )

# Here's the nps
nps(x)

#You can round it if you like
round(nps(x)) ; round(nps(x),1)
}
\author{
Brendan Rocks \email{rocks.brendan@gmail.com}
}
\seealso{
\code{\link{npc}}
}

