% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NNTintervals.R
\name{NNTintervalsRetrospective}
\alias{NNTintervalsRetrospective}
\title{NNTintervalsRetrospective}
\usage{
NNTintervalsRetrospective(Ncases = 10, Ncontrols = 30, NposCases = 6,
  NposControls = 2, prev = 0.15, alpha = 0.025, prior = c(1/2, 1/2))
}
\arguments{
\item{Ncases}{Number of cases in the study}

\item{Ncontrols}{Number of controls in the study}

\item{NposCases}{Number of cases with positive test}

\item{NposControls}{Number of controls with positive test}

\item{prev}{Prevalence of the BestToTreat (versus BestToWait)}

\item{alpha}{Significance level for interval.}

\item{prior}{Beta parameters for prior. Default is the Jeffreys prior = c(1/2,1/2). Jaynes prior = c(0,0) won't work when #fp=1.}
}
\value{
A list with 3 components containing intervals (predictive or otherwise), with names intervalsForSN, intervalsForSP, intervalsForNNT.
The intervals derive from assuming independent Jeffreys priors for SN and SP,
sampling from joint independent posteriors for SN and SP incorporating the
anticipated results, and applying NNT.from.sesp (Bayes theorem) to each
sampled pair to obtain a sample of NNTpos and NNTneg.
}
\description{
Bayes predictive intervals for sensitivity, specificity, NNTpos and NNTneg
in a case-control retrospective study.
}

