% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_data.R
\name{input_data}
\alias{input_data}
\title{Read input dataset of an nm object}
\usage{
input_data(m, filter = FALSE, na = ".", ...)
}
\arguments{
\item{m}{An nm object.}

\item{filter}{Logical (default = \code{FALSE}). Applies NONMEM ignore statement to
filter dataset.}

\item{na}{Character. Passed to \code{\link[utils:read.table]{utils::read.csv()}}}

\item{...}{Additional arguments passed to either \code{\link[=read_derived_data]{read_derived_data()}} (if
\code{\link[=write_derived_data]{write_derived_data()}} was used to create derived dataset) or
\code{\link[utils:read.table]{utils::read.csv()}}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Uses \code{data_path} field of object to locate data and read in.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))


d <- input_data(m1)
head(d)

## only non-ignored rows
d_nonignore <- input_data(m1, filter = TRUE)

}
