% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived-data-prep.R
\name{exclude_rows}
\alias{exclude_rows}
\title{Exclude rows of NONMEM dataset}
\usage{
exclude_rows(d, dexcl, exclude_col = "EXCL")
}
\arguments{
\item{d}{A \code{data.frame} for containing the full NONMEM dataset.  Should
contain a column for identifying excluded rows named with the \code{exclude_col}
argument.}

\item{dexcl}{A smaller \code{data.frame} consisting of rows to be ignored.  Need
not contain all columns of \code{d} but each column should be present in \code{d}.}

\item{exclude_col}{Character (default = \code{"EXCL"}). Name of a binary exclude
column in \code{d}. This should be accompanied with a \code{IGNORE=(EXCL.GT.0)}
statement in $DATA.}
}
\value{
A modified version of \code{d} with \code{exclude_col} set to \code{1} for rows
coinciding with \code{dexcl}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A mechanism for excluding outliers during data cleaning.  Create exploratory
plots, identify rows of the dataset to be considered outliers for exclusion,
and then feed that filtered dataset into this function to exclude them from
the dataset.  Requires a corresponding \code{IGNORE} statement - see argument
descriptions for more details.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))
             
d <- input_data(m1)
d$EXCL <- 0  ## start with no rows excluded

## use with dplyr
dexcl <- d \%>\%
  dplyr::filter(ID == 6, TIME > 3) \%>\%
  dplyr::select(ID, TIME, DV, EXCL)
dexcl ## view rows to be excluded
d <- d \%>\% exclude_rows(dexcl)

d \%>\% dplyr::filter(ID \%in\% 6)
}
\seealso{
\code{\link[=read_derived_data]{read_derived_data()}}, \code{\link[=write_derived_data]{write_derived_data()}}
}
