% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nm-gettersetters.R
\name{nm_getsetters}
\alias{nm_getsetters}
\alias{run_dir}
\alias{cmd}
\alias{type}
\alias{parent_run_id}
\alias{parent_run_in}
\alias{parent_ctl_name}
\alias{parent_results_dir}
\alias{unique_id}
\alias{ctl_name}
\alias{results_dir}
\alias{run_in}
\alias{run_id}
\alias{result_files}
\alias{lst_path}
\title{Functions to access and modify fields of nm objects}
\usage{
run_dir(m, text)

cmd(m, text)

type(m, text)

parent_run_id(m, text)

parent_run_in(m, text)

parent_ctl_name(m, text)

parent_results_dir(m, text)

unique_id(m, text)

ctl_name(m, text)

results_dir(m, text)

run_in(m, text)

run_id(m, text)

result_files(m, text)

lst_path(m, text)
}
\arguments{
\item{m}{An nm object.}

\item{text}{Optional character for replacing field. If present function will
modify field (of same name as function) otherwise will return value of
field (of same name as function).}
}
\value{
The value of the specified field of \code{m} if \code{text} is missing.
Otherwise an nm object with modified field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The fields of an object can be viewed by printing the object.  Each field has
a corresponding function of the same name to access and modify it's value.
}
\details{
Easiest way to see all fields of an object is to type the object
into the console and hit enter. This will display the value of each field.

The fundamental structure of all these functions is the same:

To access the value of a field:
\code{m \%>\% fieldname()} or equivalently \code{fieldname(m)}.

To modify the value of a field:
\code{m <- m \%>\% fieldname("newvalue")}

Some fields like \code{cmd} are glue fields.  In these cases inserting
expressions inside braces in \code{text} will evaluate the expression (see
examples).
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))


run_dir(m1)

m1 <- m1 \%>\% run_dir("{run_id}_dir")
run_dir(m1)


## set cmd field of m1
m1 <- m1 \%>\% cmd("execute {ctl_name} -dir={run_dir}")

m1 \%>\% cmd()
## displays "execute runm1.mod -dir=m1"

## can also view field when viewing object
m1
}
