% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_mosaicgibbs.R
\name{nlm_mosaicgibbs}
\alias{nlm_mosaicgibbs}
\title{nlm_mosaicgibbs}
\usage{
nlm_mosaicgibbs(ncol, nrow, resolution = 1, germs, R, patch_classes,
  rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns forming the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows forming the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{germs}{[\code{numerical(1)}]\cr
Intensity parameter (non-negative integer).}

\item{R}{[\code{numerical(1)}]\cr
Interaction radius (non-negative integer) for the fitting of the spatial point
pattern process - the min. distance between germs in map units.}

\item{patch_classes}{[\code{numerical(1)}]\cr
Number of classes for germs.}

\item{rescale}{[\code{logical(1)}]\cr If \code{TRUE} (default), the values
are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Simulate a neutral landscape model using the Gibbs algorithm introduced in Gaucherel (2008).
}
\details{
\code{nlm_mosaicgibbs} offers the second option of simulating a neutral landscape model
described in Gaucherel (2008).
The method works in principal like the tessellation method (\code{nlm_mosaictess}),
but instead of a random point pattern the algorithm fits a simulated realization of the Strauss
process. The Strauss process starts with a given number of points and
uses a minimization approach to fit a point pattern with a given interaction
parameter (0 - hardcore process; 1 - Poission process) and interaction radius
(distance of points/germs being apart).
}
\examples{
# simulate polygonal landscapes
mosaicgibbs <- nlm_mosaicgibbs(ncol = 40,
                              nrow = 30,
                              germs = 20,
                              R = 0.02,
                              patch_classes = 12)

\dontrun{
# visualize the NLM
landscapetools::show_landscape(mosaicgibbs)
}

}
\references{
Gaucherel, C. (2008) Neutral models for polygonal landscapes with linear
networks. \emph{Ecological Modelling}, 219, 39 - 48.
}
