% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_mpd.R
\name{nlm_mpd}
\alias{nlm_mpd}
\title{nlm_mpd}
\usage{
nlm_mpd(ncol, nrow, resolution = 1, roughness = 0.5, rand_dev = 1,
  rescale = TRUE, verbose = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{roughness}{[\code{numerical(1)}]\cr
Controls the level of spatial autocorrelation (!= hurst index)}

\item{rand_dev}{[\code{numerical(1)}]\cr
Initial standard deviation for the displacement step (default == 1)}

\item{rescale}{[\code{logical(1)}]\cr If \code{TRUE} (default), the values
are rescaled between 0-1.}

\item{verbose}{[\code{logical(1)}]\cr If \code{TRUE} (default), the user gets
a warning that the functions changes the dimensions to an appropriate one for
the algorithm.}
}
\value{
RasterLayer
}
\description{
Simulate a midpoint displacement neutral landscape model.
}
\details{
The algorithm is a direct implementation of the midpoint displacement
algorithm.
It performs the following steps:

\itemize{
 \item{Initialization: }{ Determine the smallest fit of
 \code{max(ncol, nrow)} in \emph{n^2 + 1} and assign value to n.
 Setup matrix of size (n^2 + 1)*(n^2 + 1).
 Afterwards, assign a random value to the four corners of the matrix.}
 \item{Diamond Step: }{ For each square in the matrix, assign the average of
 the four corner points plus a random value to the midpoint of that square.}
 \item{Diamond Step: }{ For each diamond in the matrix, assign the average
  of the four corner points plus a random value to the midpoint of that
  diamond.}
}

At each iteration the roughness, an approximation to common hurst index,
is reduced.

The image below shows the steps involved in running the diamond-square
algorithm on a 5 × 5 matrix:

\if{html}{\figure{Diamond_Square.png}{options: width="300\%" alt=""}}

(By Christopher Ewin - Own work, CC BY-SA 4.0,
https://commons.wikimedia.org/w/index.php?curid=42510593)
}
\examples{

# simulate midpoint displacement
midpoint_displacememt <- nlm_mpd(ncol = 200,
                                 nrow = 200,
                                 roughness = 0.6)
\dontrun{
# visualize the NLM
util_plot(midpoint_displacememt)
}
}
\references{
\url{https://en.wikipedia.org/wiki/Diamond-square_algorithm}
}
